/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.qdrant.QdrantComponent;

/**
 * Perform operations on the Qdrant Vector Database.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface QdrantComponentBuilderFactory {

    /**
     * Qdrant (camel-qdrant)
     * Perform operations on the Qdrant Vector Database.
     * 
     * Category: database,ai
     * Since: 4.5
     * Maven coordinates: org.apache.camel:camel-qdrant
     * 
     * @return the dsl builder
     */
    static QdrantComponentBuilder qdrant() {
        return new QdrantComponentBuilderImpl();
    }

    /**
     * Builder for the Qdrant component.
     */
    interface QdrantComponentBuilder extends ComponentBuilder<QdrantComponent> {
    
        /**
         * Sets the API key to use for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default QdrantComponentBuilder apiKey(java.lang.String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    
        /**
         * The configuration;.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.qdrant.QdrantConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default QdrantComponentBuilder configuration(org.apache.camel.component.qdrant.QdrantConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        
        /**
         * The host to connect to.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: localhost
         * Group: producer
         * 
         * @param host the value to set
         * @return the dsl builder
         */
        default QdrantComponentBuilder host(java.lang.String host) {
            doSetProperty("host", host);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default QdrantComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * Max results for similarity search.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 3
         * Group: producer
         * 
         * @param maxResults the value to set
         * @return the dsl builder
         */
        default QdrantComponentBuilder maxResults(int maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
    
        
        /**
         * The port to connect to.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 6334
         * Group: producer
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default QdrantComponentBuilder port(int port) {
            doSetProperty("port", port);
            return this;
        }
    
        /**
         * Sets a default timeout for all requests.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default QdrantComponentBuilder timeout(java.time.Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
    
        
        /**
         * Whether the client uses Transport Layer Security (TLS) to secure
         * communications.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param tls the value to set
         * @return the dsl builder
         */
        default QdrantComponentBuilder tls(boolean tls) {
            doSetProperty("tls", tls);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default QdrantComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * Filter of type io.qdrant.client.grpc.Points.Points.Filter for
         * similarity search. This is for advanced usage.
         * 
         * The option is a:
         * &lt;code&gt;io.qdrant.client.grpc.Points.Filter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param filter the value to set
         * @return the dsl builder
         */
        default QdrantComponentBuilder filter(io.qdrant.client.grpc.Points.Filter filter) {
            doSetProperty("filter", filter);
            return this;
        }
    }

    class QdrantComponentBuilderImpl
            extends AbstractComponentBuilder<QdrantComponent>
            implements QdrantComponentBuilder {
        @Override
        protected QdrantComponent buildConcreteComponent() {
            return new QdrantComponent();
        }
        private org.apache.camel.component.qdrant.QdrantConfiguration getOrCreateConfiguration(QdrantComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.qdrant.QdrantConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "apiKey": getOrCreateConfiguration((QdrantComponent) component).setApiKey((java.lang.String) value); return true;
            case "configuration": ((QdrantComponent) component).setConfiguration((org.apache.camel.component.qdrant.QdrantConfiguration) value); return true;
            case "host": getOrCreateConfiguration((QdrantComponent) component).setHost((java.lang.String) value); return true;
            case "lazyStartProducer": ((QdrantComponent) component).setLazyStartProducer((boolean) value); return true;
            case "maxResults": getOrCreateConfiguration((QdrantComponent) component).setMaxResults((int) value); return true;
            case "port": getOrCreateConfiguration((QdrantComponent) component).setPort((int) value); return true;
            case "timeout": getOrCreateConfiguration((QdrantComponent) component).setTimeout((java.time.Duration) value); return true;
            case "tls": getOrCreateConfiguration((QdrantComponent) component).setTls((boolean) value); return true;
            case "autowiredEnabled": ((QdrantComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "filter": getOrCreateConfiguration((QdrantComponent) component).setFilter((io.qdrant.client.grpc.Points.Filter) value); return true;
            default: return false;
            }
        }
    }
}