/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.debezium.postgres.DebeziumPostgresComponent;

/**
 * Capture changes from a PostgresSQL database.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface DebeziumPostgresComponentBuilderFactory {

    /**
     * Debezium PostgresSQL Connector (camel-debezium-postgres)
     * Capture changes from a PostgresSQL database.
     * 
     * Category: database
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-postgres
     * 
     * @return the dsl builder
     */
    static DebeziumPostgresComponentBuilder debeziumPostgres() {
        return new DebeziumPostgresComponentBuilderImpl();
    }

    /**
     * Builder for the Debezium PostgresSQL Connector component.
     */
    interface DebeziumPostgresComponentBuilder extends ComponentBuilder<DebeziumPostgresComponent> {
    
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;additionalProperties.schema.registry.url=http://localhost:8811/avro. This is a multi-value option with prefix: additionalProperties.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param additionalProperties the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder additionalProperties(java.util.Map<java.lang.String, java.lang.Object> additionalProperties) {
            doSetProperty("additionalProperties", additionalProperties);
            return this;
        }
    
        
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    
        /**
         * Allow pre-configured Configurations to be set.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.debezium.postgres.configuration.PostgresConnectorEmbeddedDebeziumConfiguration&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder configuration(org.apache.camel.component.debezium.postgres.configuration.PostgresConnectorEmbeddedDebeziumConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        
        /**
         * The Converter class that should be used to serialize and deserialize
         * key data for offsets. The default is JSON converter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalKeyConverter the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder internalKeyConverter(java.lang.String internalKeyConverter) {
            doSetProperty("internalKeyConverter", internalKeyConverter);
            return this;
        }
    
        
        /**
         * The Converter class that should be used to serialize and deserialize
         * value data for offsets. The default is JSON converter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalValueConverter the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder internalValueConverter(java.lang.String internalValueConverter) {
            doSetProperty("internalValueConverter", internalValueConverter);
            return this;
        }
    
        /**
         * The name of the Java class of the commit policy. It defines when
         * offsets commit has to be triggered based on the number of events
         * processed and the time elapsed since the last commit. This class must
         * implement the interface 'OffsetCommitPolicy'. The default is a
         * periodic commit policy based upon time intervals.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetCommitPolicy the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder offsetCommitPolicy(java.lang.String offsetCommitPolicy) {
            doSetProperty("offsetCommitPolicy", offsetCommitPolicy);
            return this;
        }
    
        
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param offsetCommitTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder offsetCommitTimeoutMs(long offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
    
        
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param offsetFlushIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder offsetFlushIntervalMs(long offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
    
        
        /**
         * The name of the Java class that is responsible for persistence of
         * connector offsets.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.storage.FileOffsetBackingStore
         * Group: consumer
         * 
         * @param offsetStorage the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder offsetStorage(java.lang.String offsetStorage) {
            doSetProperty("offsetStorage", offsetStorage);
            return this;
        }
    
        /**
         * Path to file where offsets are to be stored. Required when
         * offset.storage is set to the FileOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageFileName the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder offsetStorageFileName(java.lang.String offsetStorageFileName) {
            doSetProperty("offsetStorageFileName", offsetStorageFileName);
            return this;
        }
    
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStoragePartitions the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder offsetStoragePartitions(int offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
    
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageReplicationFactor the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder offsetStorageReplicationFactor(int offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
    
        /**
         * The name of the Kafka topic where offsets are to be stored. Required
         * when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageTopic the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder offsetStorageTopic(java.lang.String offsetStorageTopic) {
            doSetProperty("offsetStorageTopic", offsetStorageTopic);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        
        /**
         * Specify how binary (blob, binary, etc.) columns should be represented
         * in change events, including: 'bytes' represents binary data as byte
         * array (default); 'base64' represents binary data as base64-encoded
         * string; 'base64-url-safe' represents binary data as
         * base64-url-safe-encoded string; 'hex' represents binary data as
         * hex-encoded (base16) string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: bytes
         * Group: postgres
         * 
         * @param binaryHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder binaryHandlingMode(java.lang.String binaryHandlingMode) {
            doSetProperty("binaryHandlingMode", binaryHandlingMode);
            return this;
        }
    
        /**
         * Regular expressions matching columns to exclude from change events.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param columnExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder columnExcludeList(java.lang.String columnExcludeList) {
            doSetProperty("columnExcludeList", columnExcludeList);
            return this;
        }
    
        /**
         * Regular expressions matching columns to include in change events.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param columnIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder columnIncludeList(java.lang.String columnIncludeList) {
            doSetProperty("columnIncludeList", columnIncludeList);
            return this;
        }
    
        /**
         * A comma-separated list of regular expressions matching
         * fully-qualified names of columns that adds the columns original type
         * and original length as parameters to the corresponding field schemas
         * in the emitted change records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param columnPropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder columnPropagateSourceType(java.lang.String columnPropagateSourceType) {
            doSetProperty("columnPropagateSourceType", columnPropagateSourceType);
            return this;
        }
    
        
        /**
         * The maximum time in milliseconds to wait for connection validation to
         * complete. Defaults to 60 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1m
         * Group: postgres
         * 
         * @param connectionValidationTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder connectionValidationTimeoutMs(long connectionValidationTimeoutMs) {
            doSetProperty("connectionValidationTimeoutMs", connectionValidationTimeoutMs);
            return this;
        }
    
        /**
         * Optional list of custom converters that would be used instead of
         * default ones. The converters are defined using '.type' config option
         * and configured using options '.'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param converters the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder converters(java.lang.String converters) {
            doSetProperty("converters", converters);
            return this;
        }
    
        /**
         * The custom metric tags will accept key-value pairs to customize the
         * MBean object name which should be appended the end of regular name,
         * each key would represent a tag for the MBean object name, and the
         * corresponding value would be the value of that tag the key is. For
         * example: k1=v1,k2=v2.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param customMetricTags the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder customMetricTags(java.lang.String customMetricTags) {
            doSetProperty("customMetricTags", customMetricTags);
            return this;
        }
    
        /**
         * The name of the database from which the connector should capture
         * changes.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param databaseDbname the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databaseDbname(java.lang.String databaseDbname) {
            doSetProperty("databaseDbname", databaseDbname);
            return this;
        }
    
        /**
         * Resolvable hostname or IP address of the database server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param databaseHostname the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databaseHostname(java.lang.String databaseHostname) {
            doSetProperty("databaseHostname", databaseHostname);
            return this;
        }
    
        /**
         * A semicolon separated list of SQL statements to be executed when a
         * JDBC connection to the database is established. Note that the
         * connector may establish JDBC connections at its own discretion, so
         * this should typically be used for configuration of session parameters
         * only, but not for executing DML statements. Use doubled semicolon
         * (';;') to use a semicolon as a character and not as a delimiter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param databaseInitialStatements the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databaseInitialStatements(java.lang.String databaseInitialStatements) {
            doSetProperty("databaseInitialStatements", databaseInitialStatements);
            return this;
        }
    
        /**
         * Password of the database user to be used when connecting to the
         * database.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param databasePassword the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databasePassword(java.lang.String databasePassword) {
            doSetProperty("databasePassword", databasePassword);
            return this;
        }
    
        
        /**
         * Port of the database server.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 5432
         * Group: postgres
         * 
         * @param databasePort the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databasePort(int databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
    
        
        /**
         * Time to wait for a query to execute, given in milliseconds. Defaults
         * to 600 seconds (600,000 ms); zero means there is no limit.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10m
         * Group: postgres
         * 
         * @param databaseQueryTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databaseQueryTimeoutMs(int databaseQueryTimeoutMs) {
            doSetProperty("databaseQueryTimeoutMs", databaseQueryTimeoutMs);
            return this;
        }
    
        /**
         * File containing the SSL Certificate for the client. See the Postgres
         * SSL docs for further information.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param databaseSslcert the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databaseSslcert(java.lang.String databaseSslcert) {
            doSetProperty("databaseSslcert", databaseSslcert);
            return this;
        }
    
        /**
         * A name of class to that creates SSL Sockets. Use
         * org.postgresql.ssl.NonValidatingFactory to disable SSL validation in
         * development environments.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param databaseSslfactory the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databaseSslfactory(java.lang.String databaseSslfactory) {
            doSetProperty("databaseSslfactory", databaseSslfactory);
            return this;
        }
    
        /**
         * File containing the SSL private key for the client. See the Postgres
         * SSL docs for further information.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param databaseSslkey the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databaseSslkey(java.lang.String databaseSslkey) {
            doSetProperty("databaseSslkey", databaseSslkey);
            return this;
        }
    
        
        /**
         * Whether to use an encrypted connection to Postgres. Options include:
         * 'disable' (the default) to use an unencrypted connection; 'allow' to
         * try and use an unencrypted connection first and, failing that, a
         * secure (encrypted) connection; 'prefer' (the default) to try and use
         * a secure (encrypted) connection first and, failing that, an
         * unencrypted connection; 'require' to use a secure (encrypted)
         * connection, and fail if one cannot be established; 'verify-ca' like
         * 'required' but additionally verify the server TLS certificate against
         * the configured Certificate Authority (CA) certificates, or fail if no
         * valid matching CA certificates are found; or 'verify-full' like
         * 'verify-ca' but additionally verify that the server certificate
         * matches the host to which the connection is attempted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: prefer
         * Group: postgres
         * 
         * @param databaseSslmode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databaseSslmode(java.lang.String databaseSslmode) {
            doSetProperty("databaseSslmode", databaseSslmode);
            return this;
        }
    
        /**
         * Password to access the client private key from the file specified by
         * 'database.sslkey'. See the Postgres SSL docs for further information.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param databaseSslpassword the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databaseSslpassword(java.lang.String databaseSslpassword) {
            doSetProperty("databaseSslpassword", databaseSslpassword);
            return this;
        }
    
        /**
         * File containing the root certificate(s) against which the server is
         * validated. See the Postgres JDBC SSL docs for further information.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param databaseSslrootcert the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databaseSslrootcert(java.lang.String databaseSslrootcert) {
            doSetProperty("databaseSslrootcert", databaseSslrootcert);
            return this;
        }
    
        
        /**
         * Enable or disable TCP keep-alive probe to avoid dropping TCP
         * connection.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: postgres
         * 
         * @param databaseTcpkeepalive the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databaseTcpkeepalive(boolean databaseTcpkeepalive) {
            doSetProperty("databaseTcpkeepalive", databaseTcpkeepalive);
            return this;
        }
    
        /**
         * Name of the database user to be used when connecting to the database.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param databaseUser the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder databaseUser(java.lang.String databaseUser) {
            doSetProperty("databaseUser", databaseUser);
            return this;
        }
    
        /**
         * A comma-separated list of regular expressions matching the
         * database-specific data type names that adds the data type's original
         * type and original length as parameters to the corresponding field
         * schemas in the emitted change records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param datatypePropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder datatypePropagateSourceType(java.lang.String datatypePropagateSourceType) {
            doSetProperty("datatypePropagateSourceType", datatypePropagateSourceType);
            return this;
        }
    
        
        /**
         * Specify how DECIMAL and NUMERIC columns should be represented in
         * change events, including: 'precise' (the default) uses
         * java.math.BigDecimal to represent values, which are encoded in the
         * change events using a binary representation and Kafka Connect's
         * 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to
         * represent values; 'double' represents values using Java's 'double',
         * which may not offer the precision but will be far easier to use in
         * consumers.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: precise
         * Group: postgres
         * 
         * @param decimalHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder decimalHandlingMode(java.lang.String decimalHandlingMode) {
            doSetProperty("decimalHandlingMode", decimalHandlingMode);
            return this;
        }
    
        
        /**
         * The maximum number of retries on connection errors before failing (-1
         * = no limit, 0 = disabled, 0 = num of retries).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: postgres
         * 
         * @param errorsMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder errorsMaxRetries(int errorsMaxRetries) {
            doSetProperty("errorsMaxRetries", errorsMaxRetries);
            return this;
        }
    
        
        /**
         * Specify how failures during processing of events (i.e. when
         * encountering a corrupted event) should be handled, including: 'fail'
         * (the default) an exception indicating the problematic event and its
         * position is raised, causing the connector to be stopped; 'warn' the
         * problematic event and its position will be logged and the event will
         * be skipped; 'ignore' the problematic event will be skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: fail
         * Group: postgres
         * 
         * @param eventProcessingFailureHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder eventProcessingFailureHandlingMode(java.lang.String eventProcessingFailureHandlingMode) {
            doSetProperty("eventProcessingFailureHandlingMode", eventProcessingFailureHandlingMode);
            return this;
        }
    
        
        /**
         * The maximum time in milliseconds to wait for task executor to shut
         * down.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 4s
         * Group: postgres
         * 
         * @param executorShutdownTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder executorShutdownTimeoutMs(long executorShutdownTimeoutMs) {
            doSetProperty("executorShutdownTimeoutMs", executorShutdownTimeoutMs);
            return this;
        }
    
        
        /**
         * Enable/Disable Debezium context headers that provides essential
         * metadata for tracking and identifying the source of CDC events in
         * downstream processing systems.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: postgres
         * 
         * @param extendedHeadersEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder extendedHeadersEnabled(boolean extendedHeadersEnabled) {
            doSetProperty("extendedHeadersEnabled", extendedHeadersEnabled);
            return this;
        }
    
        
        /**
         * Boolean to determine if Debezium should flush LSN in the source
         * postgres database. If set to false, user will have to flush the LSN
         * manually outside Debezium.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: postgres
         * 
         * @param flushLsnSource the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder flushLsnSource(boolean flushLsnSource) {
            doSetProperty("flushLsnSource", flushLsnSource);
            return this;
        }
    
        /**
         * The query executed with every heartbeat.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param heartbeatActionQuery the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder heartbeatActionQuery(java.lang.String heartbeatActionQuery) {
            doSetProperty("heartbeatActionQuery", heartbeatActionQuery);
            return this;
        }
    
        
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: postgres
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder heartbeatIntervalMs(int heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
    
        
        /**
         * The prefix that is used to name heartbeat topics.Defaults to
         * __debezium-heartbeat.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: __debezium-heartbeat
         * Group: postgres
         * 
         * @param heartbeatTopicsPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder heartbeatTopicsPrefix(java.lang.String heartbeatTopicsPrefix) {
            doSetProperty("heartbeatTopicsPrefix", heartbeatTopicsPrefix);
            return this;
        }
    
        
        /**
         * Specify how HSTORE columns should be represented in change events,
         * including: 'json' represents values as string-ified JSON (default);
         * 'map' represents values as a key/value map.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: json
         * Group: postgres
         * 
         * @param hstoreHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder hstoreHandlingMode(java.lang.String hstoreHandlingMode) {
            doSetProperty("hstoreHandlingMode", hstoreHandlingMode);
            return this;
        }
    
        
        /**
         * Whether the connector parse table and column's comment to metadata
         * object. Note: Enable this option will bring the implications on
         * memory usage. The number and size of ColumnImpl objects is what
         * largely impacts how much memory is consumed by the Debezium
         * connectors, and adding a String to each of them can potentially be
         * quite heavy. The default is 'false'.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: postgres
         * 
         * @param includeSchemaComments the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder includeSchemaComments(boolean includeSchemaComments) {
            doSetProperty("includeSchemaComments", includeSchemaComments);
            return this;
        }
    
        
        /**
         * Specify whether the fields of data type not supported by Debezium
         * should be processed: 'false' (the default) omits the fields; 'true'
         * converts the field into an implementation dependent binary
         * representation.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: postgres
         * 
         * @param includeUnknownDatatypes the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder includeUnknownDatatypes(boolean includeUnknownDatatypes) {
            doSetProperty("includeUnknownDatatypes", includeUnknownDatatypes);
            return this;
        }
    
        
        /**
         * The maximum size of chunk (number of documents/rows) for incremental
         * snapshotting.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: postgres
         * 
         * @param incrementalSnapshotChunkSize the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder incrementalSnapshotChunkSize(int incrementalSnapshotChunkSize) {
            doSetProperty("incrementalSnapshotChunkSize", incrementalSnapshotChunkSize);
            return this;
        }
    
        
        /**
         * Specify the strategy used for watermarking during an incremental
         * snapshot: 'insert_insert' both open and close signal is written into
         * signal data collection (default); 'insert_delete' only open signal is
         * written on signal data collection, the close will delete the relative
         * open signal;.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: INSERT_INSERT
         * Group: postgres
         * 
         * @param incrementalSnapshotWatermarkingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder incrementalSnapshotWatermarkingStrategy(java.lang.String incrementalSnapshotWatermarkingStrategy) {
            doSetProperty("incrementalSnapshotWatermarkingStrategy", incrementalSnapshotWatermarkingStrategy);
            return this;
        }
    
        
        /**
         * Specify how INTERVAL columns should be represented in change events,
         * including: 'string' represents values as an exact ISO formatted
         * string; 'numeric' (default) represents values using the inexact
         * conversion into microseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: numeric
         * Group: postgres
         * 
         * @param intervalHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder intervalHandlingMode(java.lang.String intervalHandlingMode) {
            doSetProperty("intervalHandlingMode", intervalHandlingMode);
            return this;
        }
    
        
        /**
         * Action to take when an LSN flush timeout occurs. Options include:
         * 'fail' (default) to fail the connector; 'warn' to log a warning and
         * continue processing; 'ignore' to continue processing and ignore the
         * timeout.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: fail
         * Group: postgres
         * 
         * @param lsnFlushTimeoutAction the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder lsnFlushTimeoutAction(java.lang.String lsnFlushTimeoutAction) {
            doSetProperty("lsnFlushTimeoutAction", lsnFlushTimeoutAction);
            return this;
        }
    
        
        /**
         * Maximum time in milliseconds to wait for LSN flush operation to
         * complete. If the flush operation does not complete within this
         * timeout, the action specified by lsn.flush.timeout.action will be
         * taken. Defaults to 30 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30s
         * Group: postgres
         * 
         * @param lsnFlushTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder lsnFlushTimeoutMs(long lsnFlushTimeoutMs) {
            doSetProperty("lsnFlushTimeoutMs", lsnFlushTimeoutMs);
            return this;
        }
    
        
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2048
         * Group: postgres
         * 
         * @param maxBatchSize the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder maxBatchSize(int maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
    
        
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: postgres
         * 
         * @param maxQueueSize the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder maxQueueSize(int maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
    
        /**
         * Maximum size of the queue in bytes for change events read from the
         * database log but not yet recorded or forwarded. Defaults to 0. Mean
         * the feature is not enabled.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param maxQueueSizeInBytes the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder maxQueueSizeInBytes(long maxQueueSizeInBytes) {
            doSetProperty("maxQueueSizeInBytes", maxQueueSizeInBytes);
            return this;
        }
    
        /**
         * A semicolon-separated list of expressions that match fully-qualified
         * tables and column(s) to be used as message key. Each expression must
         * match the pattern ':', where the table names could be defined as
         * (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the
         * specific connector, and the key columns are a comma-separated list of
         * columns representing the custom key. For any table without an
         * explicit key configuration the table's primary key column(s) will be
         * used as message key. Example:
         * dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param messageKeyColumns the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder messageKeyColumns(java.lang.String messageKeyColumns) {
            doSetProperty("messageKeyColumns", messageKeyColumns);
            return this;
        }
    
        /**
         * A comma-separated list of regular expressions that match the logical
         * decoding message prefixes to be excluded from monitoring.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param messagePrefixExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder messagePrefixExcludeList(java.lang.String messagePrefixExcludeList) {
            doSetProperty("messagePrefixExcludeList", messagePrefixExcludeList);
            return this;
        }
    
        /**
         * A comma-separated list of regular expressions that match the logical
         * decoding message prefixes to be monitored. All prefixes are monitored
         * by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param messagePrefixIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder messagePrefixIncludeList(java.lang.String messagePrefixIncludeList) {
            doSetProperty("messagePrefixIncludeList", messagePrefixIncludeList);
            return this;
        }
    
        /**
         * List of notification channels names that are enabled.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param notificationEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder notificationEnabledChannels(java.lang.String notificationEnabledChannels) {
            doSetProperty("notificationEnabledChannels", notificationEnabledChannels);
            return this;
        }
    
        /**
         * The name of the topic for the notifications. This is required in case
         * 'sink' is in the list of enabled channels.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param notificationSinkTopicName the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder notificationSinkTopicName(java.lang.String notificationSinkTopicName) {
            doSetProperty("notificationSinkTopicName", notificationSinkTopicName);
            return this;
        }
    
        
        /**
         * Path to OpenLineage file configuration. See
         * https://openlineage.io/docs/client/java/configuration.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ./openlineage.yml
         * Group: postgres
         * 
         * @param openlineageIntegrationConfigFilePath the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder openlineageIntegrationConfigFilePath(java.lang.String openlineageIntegrationConfigFilePath) {
            doSetProperty("openlineageIntegrationConfigFilePath", openlineageIntegrationConfigFilePath);
            return this;
        }
    
        
        /**
         * Enable Debezium to emit data lineage metadata through OpenLineage
         * API.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: postgres
         * 
         * @param openlineageIntegrationEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder openlineageIntegrationEnabled(boolean openlineageIntegrationEnabled) {
            doSetProperty("openlineageIntegrationEnabled", openlineageIntegrationEnabled);
            return this;
        }
    
        
        /**
         * The job's description emitted by Debezium.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Debezium change data capture job
         * Group: postgres
         * 
         * @param openlineageIntegrationJobDescription the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder openlineageIntegrationJobDescription(java.lang.String openlineageIntegrationJobDescription) {
            doSetProperty("openlineageIntegrationJobDescription", openlineageIntegrationJobDescription);
            return this;
        }
    
        /**
         * The job's namespace emitted by Debezium.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param openlineageIntegrationJobNamespace the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder openlineageIntegrationJobNamespace(java.lang.String openlineageIntegrationJobNamespace) {
            doSetProperty("openlineageIntegrationJobNamespace", openlineageIntegrationJobNamespace);
            return this;
        }
    
        /**
         * The job's owners emitted by Debezium. A comma-separated list of
         * key-value pairs.For example: k1=v1,k2=v2.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param openlineageIntegrationJobOwners the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder openlineageIntegrationJobOwners(java.lang.String openlineageIntegrationJobOwners) {
            doSetProperty("openlineageIntegrationJobOwners", openlineageIntegrationJobOwners);
            return this;
        }
    
        /**
         * The job's tags emitted by Debezium. A comma-separated list of
         * key-value pairs.For example: k1=v1,k2=v2.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param openlineageIntegrationJobTags the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder openlineageIntegrationJobTags(java.lang.String openlineageIntegrationJobTags) {
            doSetProperty("openlineageIntegrationJobTags", openlineageIntegrationJobTags);
            return this;
        }
    
        
        /**
         * The name of the Postgres logical decoding plugin installed on the
         * server. Supported values are 'decoderbufs' and 'pgoutput'. Defaults
         * to 'decoderbufs'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: decoderbufs
         * Group: postgres
         * 
         * @param pluginName the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder pluginName(java.lang.String pluginName) {
            doSetProperty("pluginName", pluginName);
            return this;
        }
    
        
        /**
         * Time to wait for new change events to appear after receiving no
         * events, given in milliseconds. Defaults to 500 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500ms
         * Group: postgres
         * 
         * @param pollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder pollIntervalMs(long pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
    
        /**
         * Optional list of post processors. The processors are defined using
         * '.type' config option and configured using options ''.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param postProcessors the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder postProcessors(java.lang.String postProcessors) {
            doSetProperty("postProcessors", postProcessors);
            return this;
        }
    
        
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: postgres
         * 
         * @param provideTransactionMetadata the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder provideTransactionMetadata(boolean provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
    
        
        /**
         * Applies only when streaming changes using pgoutput.Determine how
         * creation of a publication should work, the default is
         * all_tables.DISABLED - The connector will not attempt to create a
         * publication at all. The expectation is that the user has created the
         * publication up-front. If the publication isn't found to exist upon
         * startup, the connector will throw an exception and stop.ALL_TABLES -
         * If no publication exists, the connector will create a new publication
         * for all tables. Note this requires that the configured user has
         * access. If the publication already exists, it will be used. i.e
         * CREATE PUBLICATION FOR ALL TABLES;FILTERED - If no publication
         * exists, the connector will create a new publication for all those
         * tables matchingthe current filter configuration (see table/database
         * include/exclude list properties). If the publication already exists,
         * it will be used. i.e CREATE PUBLICATION FOR TABLE.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: all_tables
         * Group: postgres
         * 
         * @param publicationAutocreateMode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder publicationAutocreateMode(java.lang.String publicationAutocreateMode) {
            doSetProperty("publicationAutocreateMode", publicationAutocreateMode);
            return this;
        }
    
        
        /**
         * The name of the Postgres 10 publication used for streaming changes
         * from a plugin. Defaults to 'dbz_publication'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: dbz_publication
         * Group: postgres
         * 
         * @param publicationName the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder publicationName(java.lang.String publicationName) {
            doSetProperty("publicationName", publicationName);
            return this;
        }
    
        
        /**
         * A boolean that determines whether the connector should publish
         * changes via the partition root. When true, changes are published
         * through partition root. When false, changes are published directly.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: postgres
         * 
         * @param publishViaPartitionRoot the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder publishViaPartitionRoot(boolean publishViaPartitionRoot) {
            doSetProperty("publishViaPartitionRoot", publishViaPartitionRoot);
            return this;
        }
    
        /**
         * The maximum number of records that should be loaded into memory while
         * streaming. A value of '0' uses the default JDBC fetch size.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param queryFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder queryFetchSize(int queryFetchSize) {
            doSetProperty("queryFetchSize", queryFetchSize);
            return this;
        }
    
        /**
         * Applies only when streaming changes using pgoutput.Determines the
         * value for Replica Identity at table level. This option will overwrite
         * the existing value in databaseA comma-separated list of regular
         * expressions that match fully-qualified tables and Replica Identity
         * value to be used in the table. Each expression must match the pattern
         * ':', where the table names could be defined as
         * (SCHEMA_NAME.TABLE_NAME), and the replica identity values are:
         * DEFAULT - Records the old values of the columns of the primary key,
         * if any. This is the default for non-system tables.INDEX index_name -
         * Records the old values of the columns covered by the named index,
         * that must be unique, not partial, not deferrable, and include only
         * columns marked NOT NULL. If this index is dropped, the behavior is
         * the same as NOTHING.FULL - Records the old values of all columns in
         * the row.NOTHING - Records no information about the old row. This is
         * the default for system tables.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param replicaIdentityAutosetValues the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder replicaIdentityAutosetValues(java.lang.String replicaIdentityAutosetValues) {
            doSetProperty("replicaIdentityAutosetValues", replicaIdentityAutosetValues);
            return this;
        }
    
        
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: postgres
         * 
         * @param retriableRestartConnectorWaitMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder retriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
    
        /**
         * The schemas for which events must not be captured.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param schemaExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder schemaExcludeList(java.lang.String schemaExcludeList) {
            doSetProperty("schemaExcludeList", schemaExcludeList);
            return this;
        }
    
        /**
         * The path to the file that will be used to record the database schema
         * history.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param schemaHistoryInternalFileFilename the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder schemaHistoryInternalFileFilename(java.lang.String schemaHistoryInternalFileFilename) {
            doSetProperty("schemaHistoryInternalFileFilename", schemaHistoryInternalFileFilename);
            return this;
        }
    
        /**
         * The schemas for which events should be captured.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param schemaIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder schemaIncludeList(java.lang.String schemaIncludeList) {
            doSetProperty("schemaIncludeList", schemaIncludeList);
            return this;
        }
    
        
        /**
         * Specify how schema names should be adjusted for compatibility with
         * the message converter used by the connector, including: 'avro'
         * replaces the characters that cannot be used in the Avro type name
         * with underscore; 'avro_unicode' replaces the underscore or characters
         * that cannot be used in the Avro type name with corresponding unicode
         * like _uxxxx. Note: _ is an escape sequence like backslash in
         * Java;'none' does not apply any adjustment (default).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: none
         * Group: postgres
         * 
         * @param schemaNameAdjustmentMode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder schemaNameAdjustmentMode(java.lang.String schemaNameAdjustmentMode) {
            doSetProperty("schemaNameAdjustmentMode", schemaNameAdjustmentMode);
            return this;
        }
    
        
        /**
         * Specify the conditions that trigger a refresh of the in-memory schema
         * for a table. 'columns_diff' (the default) is the safest mode,
         * ensuring the in-memory schema stays in-sync with the database table's
         * schema at all times. 'columns_diff_exclude_unchanged_toast' instructs
         * the connector to refresh the in-memory schema cache if there is a
         * discrepancy between it and the schema derived from the incoming
         * message, unless unchanged TOASTable data fully accounts for the
         * discrepancy. This setting can improve connector performance
         * significantly if there are frequently-updated tables that have
         * TOASTed data that are rarely part of these updates. However, it is
         * possible for the in-memory schema to become outdated if TOASTable
         * columns are dropped from the table.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: columns_diff
         * Group: postgres
         * 
         * @param schemaRefreshMode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder schemaRefreshMode(java.lang.String schemaRefreshMode) {
            doSetProperty("schemaRefreshMode", schemaRefreshMode);
            return this;
        }
    
        /**
         * The name of the data collection that is used to send signals/commands
         * to Debezium. Signaling is disabled when not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param signalDataCollection the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder signalDataCollection(java.lang.String signalDataCollection) {
            doSetProperty("signalDataCollection", signalDataCollection);
            return this;
        }
    
        
        /**
         * List of channels names that are enabled. Source channel is enabled by
         * default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: source
         * Group: postgres
         * 
         * @param signalEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder signalEnabledChannels(java.lang.String signalEnabledChannels) {
            doSetProperty("signalEnabledChannels", signalEnabledChannels);
            return this;
        }
    
        
        /**
         * Interval for looking for new signals in registered channels, given in
         * milliseconds. Defaults to 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5s
         * Group: postgres
         * 
         * @param signalPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder signalPollIntervalMs(long signalPollIntervalMs) {
            doSetProperty("signalPollIntervalMs", signalPollIntervalMs);
            return this;
        }
    
        
        /**
         * The comma-separated list of operations to skip during streaming,
         * defined as: 'c' for inserts/create; 'u' for updates; 'd' for deletes,
         * 't' for truncates, and 'none' to indicate nothing skipped. By
         * default, only truncate operations will be skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: t
         * Group: postgres
         * 
         * @param skippedOperations the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder skippedOperations(java.lang.String skippedOperations) {
            doSetProperty("skippedOperations", skippedOperations);
            return this;
        }
    
        
        /**
         * Whether or not to drop the logical replication slot when the
         * connector finishes orderly. By default the replication is kept so
         * that on restart progress can resume from the last recorded location.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: postgres
         * 
         * @param slotDropOnStop the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder slotDropOnStop(boolean slotDropOnStop) {
            doSetProperty("slotDropOnStop", slotDropOnStop);
            return this;
        }
    
        
        /**
         * Whether or not to create a failover slot. This is only supported when
         * connecting to a primary server of a Postgres cluster, version 17 or
         * newer. When not specified, or when not connecting to a Postgres 17
         * primary, no failover slot will be created.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: postgres
         * 
         * @param slotFailover the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder slotFailover(boolean slotFailover) {
            doSetProperty("slotFailover", slotFailover);
            return this;
        }
    
        
        /**
         * How many times to retry connecting to a replication slot when an
         * attempt fails.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 6
         * Group: postgres
         * 
         * @param slotMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder slotMaxRetries(int slotMaxRetries) {
            doSetProperty("slotMaxRetries", slotMaxRetries);
            return this;
        }
    
        
        /**
         * The name of the Postgres logical decoding slot created for streaming
         * changes from a plugin. Defaults to 'debezium.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: debezium
         * Group: postgres
         * 
         * @param slotName the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder slotName(java.lang.String slotName) {
            doSetProperty("slotName", slotName);
            return this;
        }
    
        
        /**
         * Time to wait between retry attempts when the connector fails to
         * connect to a replication slot, given in milliseconds. Defaults to 10
         * seconds (10,000 ms).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: postgres
         * 
         * @param slotRetryDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder slotRetryDelayMs(long slotRetryDelayMs) {
            doSetProperty("slotRetryDelayMs", slotRetryDelayMs);
            return this;
        }
    
        /**
         * Any optional parameters used by logical decoding plugin. Semi-colon
         * separated. E.g.
         * 'add-tables=public.table,public.table2;include-lsn=true'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param slotStreamParams the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder slotStreamParams(java.lang.String slotStreamParams) {
            doSetProperty("slotStreamParams", slotStreamParams);
            return this;
        }
    
        
        /**
         * A delay period before a snapshot will begin, given in milliseconds.
         * Defaults to 0 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: postgres
         * 
         * @param snapshotDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotDelayMs(long snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
    
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param snapshotFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotFetchSize(int snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
    
        /**
         * This setting must be set to specify a list of tables/collections
         * whose snapshot must be taken on creating or restarting the connector.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param snapshotIncludeCollectionList the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotIncludeCollectionList(java.lang.String snapshotIncludeCollectionList) {
            doSetProperty("snapshotIncludeCollectionList", snapshotIncludeCollectionList);
            return this;
        }
    
        
        /**
         * Controls which transaction isolation level is used. The default is
         * 'serializable', which means that serializable isolation level is
         * used. When 'repeatable_read' is specified, connector runs the initial
         * snapshot in REPEATABLE READ isolation level. When 'read_committed' is
         * specified, connector runs the initial snapshot in READ COMMITTED
         * isolation level. In 'read_uncommitted' is specified, connector runs
         * the initial snapshot in READ UNCOMMITTED isolation level.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: serializable
         * Group: postgres
         * 
         * @param snapshotIsolationMode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotIsolationMode(java.lang.String snapshotIsolationMode) {
            doSetProperty("snapshotIsolationMode", snapshotIsolationMode);
            return this;
        }
    
        
        /**
         * Controls how the connector holds locks on tables while performing the
         * schema snapshot. The 'shared' which means the connector will hold a
         * table lock that prevents exclusive table access for just the initial
         * portion of the snapshot while the database schemas and other metadata
         * are being read. The remaining work in a snapshot involves selecting
         * all rows from each table, and this is done using a flashback query
         * that requires no locks. However, in some cases it may be desirable to
         * avoid locks entirely which can be done by specifying 'none'. This
         * mode is only safe to use if no schema changes are happening while the
         * snapshot is taken.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: none
         * Group: postgres
         * 
         * @param snapshotLockingMode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotLockingMode(java.lang.String snapshotLockingMode) {
            doSetProperty("snapshotLockingMode", snapshotLockingMode);
            return this;
        }
    
        /**
         * When 'snapshot.locking.mode' is set as custom, this setting must be
         * set to specify a the name of the custom implementation provided in
         * the 'name()' method. The implementations must implement the
         * 'SnapshotterLocking' interface and is called to determine how to lock
         * tables during schema snapshot.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param snapshotLockingModeCustomName the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotLockingModeCustomName(java.lang.String snapshotLockingModeCustomName) {
            doSetProperty("snapshotLockingModeCustomName", snapshotLockingModeCustomName);
            return this;
        }
    
        
        /**
         * The maximum number of millis to wait for table locks at the beginning
         * of a snapshot. If locks cannot be acquired in this time frame, the
         * snapshot will be aborted. Defaults to 10 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: postgres
         * 
         * @param snapshotLockTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotLockTimeoutMs(long snapshotLockTimeoutMs) {
            doSetProperty("snapshotLockTimeoutMs", snapshotLockTimeoutMs);
            return this;
        }
    
        
        /**
         * The maximum number of threads used to perform the snapshot. Defaults
         * to 1.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: postgres
         * 
         * @param snapshotMaxThreads the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotMaxThreads(int snapshotMaxThreads) {
            doSetProperty("snapshotMaxThreads", snapshotMaxThreads);
            return this;
        }
    
        
        /**
         * The criteria for running a snapshot upon startup of the connector.
         * Select one of the following snapshot options: 'always': The connector
         * runs a snapshot every time that it starts. After the snapshot
         * completes, the connector begins to stream changes from the
         * transaction log.; 'initial' (default): If the connector does not
         * detect any offsets for the logical server name, it runs a snapshot
         * that captures the current full state of the configured tables. After
         * the snapshot completes, the connector begins to stream changes from
         * the transaction log. 'initial_only': The connector performs a
         * snapshot as it does for the 'initial' option, but after the connector
         * completes the snapshot, it stops, and does not stream changes from
         * the transaction log.; 'never': The connector does not run a snapshot.
         * Upon first startup, the connector immediately begins reading from the
         * beginning of the transaction log. 'exported': This option is
         * deprecated; use 'initial' instead.; 'custom': The connector loads a
         * custom class to specify how the connector performs snapshots. For
         * more information, see Custom snapshotter SPI in the PostgreSQL
         * connector documentation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: initial
         * Group: postgres
         * 
         * @param snapshotMode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotMode(java.lang.String snapshotMode) {
            doSetProperty("snapshotMode", snapshotMode);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: postgres
         * 
         * @param snapshotModeConfigurationBasedSnapshotData the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotModeConfigurationBasedSnapshotData(boolean snapshotModeConfigurationBasedSnapshotData) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotData", snapshotModeConfigurationBasedSnapshotData);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not in
         * case of error.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: postgres
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnDataError the value to
         * set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotModeConfigurationBasedSnapshotOnDataError(boolean snapshotModeConfigurationBasedSnapshotOnDataError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnDataError", snapshotModeConfigurationBasedSnapshotOnDataError);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not
         * in case of error.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: postgres
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnSchemaError the value
         * to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotModeConfigurationBasedSnapshotOnSchemaError(boolean snapshotModeConfigurationBasedSnapshotOnSchemaError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnSchemaError", snapshotModeConfigurationBasedSnapshotOnSchemaError);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: postgres
         * 
         * @param snapshotModeConfigurationBasedSnapshotSchema the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotModeConfigurationBasedSnapshotSchema(boolean snapshotModeConfigurationBasedSnapshotSchema) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotSchema", snapshotModeConfigurationBasedSnapshotSchema);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the stream should start or not after
         * snapshot.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: postgres
         * 
         * @param snapshotModeConfigurationBasedStartStream the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotModeConfigurationBasedStartStream(boolean snapshotModeConfigurationBasedStartStream) {
            doSetProperty("snapshotModeConfigurationBasedStartStream", snapshotModeConfigurationBasedStartStream);
            return this;
        }
    
        /**
         * When 'snapshot.mode' is set as custom, this setting must be set to
         * specify a the name of the custom implementation provided in the
         * 'name()' method. The implementations must implement the 'Snapshotter'
         * interface and is called on each app boot to determine whether to do a
         * snapshot.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param snapshotModeCustomName the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotModeCustomName(java.lang.String snapshotModeCustomName) {
            doSetProperty("snapshotModeCustomName", snapshotModeCustomName);
            return this;
        }
    
        
        /**
         * Controls query used during the snapshot.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: select_all
         * Group: postgres
         * 
         * @param snapshotQueryMode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotQueryMode(java.lang.String snapshotQueryMode) {
            doSetProperty("snapshotQueryMode", snapshotQueryMode);
            return this;
        }
    
        /**
         * When 'snapshot.query.mode' is set as custom, this setting must be set
         * to specify a the name of the custom implementation provided in the
         * 'name()' method. The implementations must implement the
         * 'SnapshotterQuery' interface and is called to determine how to build
         * queries during snapshot.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param snapshotQueryModeCustomName the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotQueryModeCustomName(java.lang.String snapshotQueryModeCustomName) {
            doSetProperty("snapshotQueryModeCustomName", snapshotQueryModeCustomName);
            return this;
        }
    
        /**
         * This property contains a comma-separated list of fully-qualified
         * tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on
         * the specific connectors. Select statements for the individual tables
         * are specified in further configuration properties, one for each
         * table, identified by the id
         * 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or
         * 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME',
         * respectively. The value of those properties is the select statement
         * to use when retrieving data from the specific table during
         * snapshotting. A possible use case for large append-only tables is
         * setting a specific point where to start (resume) snapshotting, in
         * case a previous snapshotting was interrupted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param snapshotSelectStatementOverrides the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotSelectStatementOverrides(java.lang.String snapshotSelectStatementOverrides) {
            doSetProperty("snapshotSelectStatementOverrides", snapshotSelectStatementOverrides);
            return this;
        }
    
        
        /**
         * Controls the order in which tables are processed in the initial
         * snapshot. A descending value will order the tables by row count
         * descending. A ascending value will order the tables by row count
         * ascending. A value of disabled (the default) will disable ordering by
         * row count.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: disabled
         * Group: postgres
         * 
         * @param snapshotTablesOrderByRowCount the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder snapshotTablesOrderByRowCount(java.lang.String snapshotTablesOrderByRowCount) {
            doSetProperty("snapshotTablesOrderByRowCount", snapshotTablesOrderByRowCount);
            return this;
        }
    
        
        /**
         * The name of the SourceInfoStructMaker class that returns SourceInfo
         * schema and struct.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default:
         * io.debezium.connector.postgresql.PostgresSourceInfoStructMaker
         * Group: postgres
         * 
         * @param sourceinfoStructMaker the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder sourceinfoStructMaker(java.lang.String sourceinfoStructMaker) {
            doSetProperty("sourceinfoStructMaker", sourceinfoStructMaker);
            return this;
        }
    
        
        /**
         * Frequency for sending replication connection status updates to the
         * server, given in milliseconds. Defaults to 10 seconds (10,000 ms).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: postgres
         * 
         * @param statusUpdateIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder statusUpdateIntervalMs(int statusUpdateIntervalMs) {
            doSetProperty("statusUpdateIntervalMs", statusUpdateIntervalMs);
            return this;
        }
    
        
        /**
         * A delay period after the snapshot is completed and the streaming
         * begins, given in milliseconds. Defaults to 0 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: postgres
         * 
         * @param streamingDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder streamingDelayMs(long streamingDelayMs) {
            doSetProperty("streamingDelayMs", streamingDelayMs);
            return this;
        }
    
        /**
         * A comma-separated list of regular expressions that match the
         * fully-qualified names of tables to be excluded from monitoring.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param tableExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder tableExcludeList(java.lang.String tableExcludeList) {
            doSetProperty("tableExcludeList", tableExcludeList);
            return this;
        }
    
        
        /**
         * Flag specifying whether built-in tables should be ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: postgres
         * 
         * @param tableIgnoreBuiltin the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder tableIgnoreBuiltin(boolean tableIgnoreBuiltin) {
            doSetProperty("tableIgnoreBuiltin", tableIgnoreBuiltin);
            return this;
        }
    
        /**
         * The tables for which changes are to be captured.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param tableIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder tableIncludeList(java.lang.String tableIncludeList) {
            doSetProperty("tableIncludeList", tableIncludeList);
            return this;
        }
    
        
        /**
         * Time, date, and timestamps can be represented with different kinds of
         * precisions, including: 'adaptive' (the default) bases the precision
         * of time, date, and timestamp values on the database column's
         * precision; 'adaptive_time_microseconds' like 'adaptive' mode, but
         * TIME fields always use microseconds precision; 'connect' always
         * represents time, date, and timestamp values using Kafka Connect's
         * built-in representations for Time, Date, and Timestamp, which uses
         * millisecond precision regardless of the database columns' precision.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: adaptive
         * Group: postgres
         * 
         * @param timePrecisionMode the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder timePrecisionMode(java.lang.String timePrecisionMode) {
            doSetProperty("timePrecisionMode", timePrecisionMode);
            return this;
        }
    
        
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsequent tombstone event (true) or only by a delete event
         * (false). Emitting the tombstone event (the default behavior) allows
         * Kafka to completely delete all events pertaining to the given key
         * once the source record got deleted.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: postgres
         * 
         * @param tombstonesOnDelete the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder tombstonesOnDelete(boolean tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
    
        
        /**
         * The name of the TopicNamingStrategy class that should be used to
         * determine the topic name for data change, schema change, transaction,
         * heartbeat event etc.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.debezium.schema.SchemaTopicNamingStrategy
         * Group: postgres
         * 
         * @param topicNamingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder topicNamingStrategy(java.lang.String topicNamingStrategy) {
            doSetProperty("topicNamingStrategy", topicNamingStrategy);
            return this;
        }
    
        /**
         * Topic prefix that identifies and provides a namespace for the
         * particular database server/cluster is capturing changes. The topic
         * prefix should be unique across all other connectors, since it is used
         * as a prefix for all Kafka topic names that receive events emitted by
         * this connector. Only alphanumeric characters, hyphens, dots and
         * underscores must be accepted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: postgres
         * 
         * @param topicPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder topicPrefix(java.lang.String topicPrefix) {
            doSetProperty("topicPrefix", topicPrefix);
            return this;
        }
    
        
        /**
         * Class to make transaction context &amp; transaction struct/schemas.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default:
         * io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory
         * Group: postgres
         * 
         * @param transactionMetadataFactory the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder transactionMetadataFactory(java.lang.String transactionMetadataFactory) {
            doSetProperty("transactionMetadataFactory", transactionMetadataFactory);
            return this;
        }
    
        
        /**
         * Specify the constant that will be provided by Debezium to indicate
         * that the original value is a toasted value not provided by the
         * database. If starts with 'hex:' prefix it is expected that the rest
         * of the string represents hexadecimal encoded octets.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: __debezium_unavailable_value
         * Group: postgres
         * 
         * @param unavailableValuePlaceholder the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder unavailableValuePlaceholder(java.lang.String unavailableValuePlaceholder) {
            doSetProperty("unavailableValuePlaceholder", unavailableValuePlaceholder);
            return this;
        }
    
        
        /**
         * Specify how often (in ms) the xmin will be fetched from the
         * replication slot. This xmin value is exposed by the slot which gives
         * a lower bound of where a new replication slot could start from. The
         * lower the value, the more likely this value is to be the current
         * 'true' value, but the bigger the performance cost. The bigger the
         * value, the less likely this value is to be the current 'true' value,
         * but the lower the performance penalty. The default is set to 0 ms,
         * which disables tracking xmin.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: postgres
         * 
         * @param xminFetchIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumPostgresComponentBuilder xminFetchIntervalMs(long xminFetchIntervalMs) {
            doSetProperty("xminFetchIntervalMs", xminFetchIntervalMs);
            return this;
        }
    }

    class DebeziumPostgresComponentBuilderImpl
            extends AbstractComponentBuilder<DebeziumPostgresComponent>
            implements DebeziumPostgresComponentBuilder {
        @Override
        protected DebeziumPostgresComponent buildConcreteComponent() {
            return new DebeziumPostgresComponent();
        }
        private org.apache.camel.component.debezium.postgres.configuration.PostgresConnectorEmbeddedDebeziumConfiguration getOrCreateConfiguration(DebeziumPostgresComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.debezium.postgres.configuration.PostgresConnectorEmbeddedDebeziumConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "additionalProperties": getOrCreateConfiguration((DebeziumPostgresComponent) component).setAdditionalProperties((java.util.Map) value); return true;
            case "bridgeErrorHandler": ((DebeziumPostgresComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "configuration": ((DebeziumPostgresComponent) component).setConfiguration((org.apache.camel.component.debezium.postgres.configuration.PostgresConnectorEmbeddedDebeziumConfiguration) value); return true;
            case "internalKeyConverter": getOrCreateConfiguration((DebeziumPostgresComponent) component).setInternalKeyConverter((java.lang.String) value); return true;
            case "internalValueConverter": getOrCreateConfiguration((DebeziumPostgresComponent) component).setInternalValueConverter((java.lang.String) value); return true;
            case "offsetCommitPolicy": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOffsetCommitPolicy((java.lang.String) value); return true;
            case "offsetCommitTimeoutMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOffsetCommitTimeoutMs((long) value); return true;
            case "offsetFlushIntervalMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOffsetFlushIntervalMs((long) value); return true;
            case "offsetStorage": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOffsetStorage((java.lang.String) value); return true;
            case "offsetStorageFileName": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOffsetStorageFileName((java.lang.String) value); return true;
            case "offsetStoragePartitions": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOffsetStoragePartitions((int) value); return true;
            case "offsetStorageReplicationFactor": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOffsetStorageReplicationFactor((int) value); return true;
            case "offsetStorageTopic": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOffsetStorageTopic((java.lang.String) value); return true;
            case "autowiredEnabled": ((DebeziumPostgresComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "binaryHandlingMode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setBinaryHandlingMode((java.lang.String) value); return true;
            case "columnExcludeList": getOrCreateConfiguration((DebeziumPostgresComponent) component).setColumnExcludeList((java.lang.String) value); return true;
            case "columnIncludeList": getOrCreateConfiguration((DebeziumPostgresComponent) component).setColumnIncludeList((java.lang.String) value); return true;
            case "columnPropagateSourceType": getOrCreateConfiguration((DebeziumPostgresComponent) component).setColumnPropagateSourceType((java.lang.String) value); return true;
            case "connectionValidationTimeoutMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setConnectionValidationTimeoutMs((long) value); return true;
            case "converters": getOrCreateConfiguration((DebeziumPostgresComponent) component).setConverters((java.lang.String) value); return true;
            case "customMetricTags": getOrCreateConfiguration((DebeziumPostgresComponent) component).setCustomMetricTags((java.lang.String) value); return true;
            case "databaseDbname": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabaseDbname((java.lang.String) value); return true;
            case "databaseHostname": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabaseHostname((java.lang.String) value); return true;
            case "databaseInitialStatements": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabaseInitialStatements((java.lang.String) value); return true;
            case "databasePassword": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabasePassword((java.lang.String) value); return true;
            case "databasePort": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabasePort((int) value); return true;
            case "databaseQueryTimeoutMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabaseQueryTimeoutMs((int) value); return true;
            case "databaseSslcert": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabaseSslcert((java.lang.String) value); return true;
            case "databaseSslfactory": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabaseSslfactory((java.lang.String) value); return true;
            case "databaseSslkey": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabaseSslkey((java.lang.String) value); return true;
            case "databaseSslmode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabaseSslmode((java.lang.String) value); return true;
            case "databaseSslpassword": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabaseSslpassword((java.lang.String) value); return true;
            case "databaseSslrootcert": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabaseSslrootcert((java.lang.String) value); return true;
            case "databaseTcpkeepalive": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabaseTcpkeepalive((boolean) value); return true;
            case "databaseUser": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatabaseUser((java.lang.String) value); return true;
            case "datatypePropagateSourceType": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDatatypePropagateSourceType((java.lang.String) value); return true;
            case "decimalHandlingMode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setDecimalHandlingMode((java.lang.String) value); return true;
            case "errorsMaxRetries": getOrCreateConfiguration((DebeziumPostgresComponent) component).setErrorsMaxRetries((int) value); return true;
            case "eventProcessingFailureHandlingMode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setEventProcessingFailureHandlingMode((java.lang.String) value); return true;
            case "executorShutdownTimeoutMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setExecutorShutdownTimeoutMs((long) value); return true;
            case "extendedHeadersEnabled": getOrCreateConfiguration((DebeziumPostgresComponent) component).setExtendedHeadersEnabled((boolean) value); return true;
            case "flushLsnSource": getOrCreateConfiguration((DebeziumPostgresComponent) component).setFlushLsnSource((boolean) value); return true;
            case "heartbeatActionQuery": getOrCreateConfiguration((DebeziumPostgresComponent) component).setHeartbeatActionQuery((java.lang.String) value); return true;
            case "heartbeatIntervalMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setHeartbeatIntervalMs((int) value); return true;
            case "heartbeatTopicsPrefix": getOrCreateConfiguration((DebeziumPostgresComponent) component).setHeartbeatTopicsPrefix((java.lang.String) value); return true;
            case "hstoreHandlingMode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setHstoreHandlingMode((java.lang.String) value); return true;
            case "includeSchemaComments": getOrCreateConfiguration((DebeziumPostgresComponent) component).setIncludeSchemaComments((boolean) value); return true;
            case "includeUnknownDatatypes": getOrCreateConfiguration((DebeziumPostgresComponent) component).setIncludeUnknownDatatypes((boolean) value); return true;
            case "incrementalSnapshotChunkSize": getOrCreateConfiguration((DebeziumPostgresComponent) component).setIncrementalSnapshotChunkSize((int) value); return true;
            case "incrementalSnapshotWatermarkingStrategy": getOrCreateConfiguration((DebeziumPostgresComponent) component).setIncrementalSnapshotWatermarkingStrategy((java.lang.String) value); return true;
            case "intervalHandlingMode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setIntervalHandlingMode((java.lang.String) value); return true;
            case "lsnFlushTimeoutAction": getOrCreateConfiguration((DebeziumPostgresComponent) component).setLsnFlushTimeoutAction((java.lang.String) value); return true;
            case "lsnFlushTimeoutMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setLsnFlushTimeoutMs((long) value); return true;
            case "maxBatchSize": getOrCreateConfiguration((DebeziumPostgresComponent) component).setMaxBatchSize((int) value); return true;
            case "maxQueueSize": getOrCreateConfiguration((DebeziumPostgresComponent) component).setMaxQueueSize((int) value); return true;
            case "maxQueueSizeInBytes": getOrCreateConfiguration((DebeziumPostgresComponent) component).setMaxQueueSizeInBytes((long) value); return true;
            case "messageKeyColumns": getOrCreateConfiguration((DebeziumPostgresComponent) component).setMessageKeyColumns((java.lang.String) value); return true;
            case "messagePrefixExcludeList": getOrCreateConfiguration((DebeziumPostgresComponent) component).setMessagePrefixExcludeList((java.lang.String) value); return true;
            case "messagePrefixIncludeList": getOrCreateConfiguration((DebeziumPostgresComponent) component).setMessagePrefixIncludeList((java.lang.String) value); return true;
            case "notificationEnabledChannels": getOrCreateConfiguration((DebeziumPostgresComponent) component).setNotificationEnabledChannels((java.lang.String) value); return true;
            case "notificationSinkTopicName": getOrCreateConfiguration((DebeziumPostgresComponent) component).setNotificationSinkTopicName((java.lang.String) value); return true;
            case "openlineageIntegrationConfigFilePath": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOpenlineageIntegrationConfigFilePath((java.lang.String) value); return true;
            case "openlineageIntegrationEnabled": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOpenlineageIntegrationEnabled((boolean) value); return true;
            case "openlineageIntegrationJobDescription": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOpenlineageIntegrationJobDescription((java.lang.String) value); return true;
            case "openlineageIntegrationJobNamespace": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOpenlineageIntegrationJobNamespace((java.lang.String) value); return true;
            case "openlineageIntegrationJobOwners": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOpenlineageIntegrationJobOwners((java.lang.String) value); return true;
            case "openlineageIntegrationJobTags": getOrCreateConfiguration((DebeziumPostgresComponent) component).setOpenlineageIntegrationJobTags((java.lang.String) value); return true;
            case "pluginName": getOrCreateConfiguration((DebeziumPostgresComponent) component).setPluginName((java.lang.String) value); return true;
            case "pollIntervalMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setPollIntervalMs((long) value); return true;
            case "postProcessors": getOrCreateConfiguration((DebeziumPostgresComponent) component).setPostProcessors((java.lang.String) value); return true;
            case "provideTransactionMetadata": getOrCreateConfiguration((DebeziumPostgresComponent) component).setProvideTransactionMetadata((boolean) value); return true;
            case "publicationAutocreateMode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setPublicationAutocreateMode((java.lang.String) value); return true;
            case "publicationName": getOrCreateConfiguration((DebeziumPostgresComponent) component).setPublicationName((java.lang.String) value); return true;
            case "publishViaPartitionRoot": getOrCreateConfiguration((DebeziumPostgresComponent) component).setPublishViaPartitionRoot((boolean) value); return true;
            case "queryFetchSize": getOrCreateConfiguration((DebeziumPostgresComponent) component).setQueryFetchSize((int) value); return true;
            case "replicaIdentityAutosetValues": getOrCreateConfiguration((DebeziumPostgresComponent) component).setReplicaIdentityAutosetValues((java.lang.String) value); return true;
            case "retriableRestartConnectorWaitMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setRetriableRestartConnectorWaitMs((long) value); return true;
            case "schemaExcludeList": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSchemaExcludeList((java.lang.String) value); return true;
            case "schemaHistoryInternalFileFilename": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSchemaHistoryInternalFileFilename((java.lang.String) value); return true;
            case "schemaIncludeList": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSchemaIncludeList((java.lang.String) value); return true;
            case "schemaNameAdjustmentMode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSchemaNameAdjustmentMode((java.lang.String) value); return true;
            case "schemaRefreshMode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSchemaRefreshMode((java.lang.String) value); return true;
            case "signalDataCollection": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSignalDataCollection((java.lang.String) value); return true;
            case "signalEnabledChannels": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSignalEnabledChannels((java.lang.String) value); return true;
            case "signalPollIntervalMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSignalPollIntervalMs((long) value); return true;
            case "skippedOperations": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSkippedOperations((java.lang.String) value); return true;
            case "slotDropOnStop": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSlotDropOnStop((boolean) value); return true;
            case "slotFailover": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSlotFailover((boolean) value); return true;
            case "slotMaxRetries": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSlotMaxRetries((int) value); return true;
            case "slotName": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSlotName((java.lang.String) value); return true;
            case "slotRetryDelayMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSlotRetryDelayMs((long) value); return true;
            case "slotStreamParams": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSlotStreamParams((java.lang.String) value); return true;
            case "snapshotDelayMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotDelayMs((long) value); return true;
            case "snapshotFetchSize": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotFetchSize((int) value); return true;
            case "snapshotIncludeCollectionList": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotIncludeCollectionList((java.lang.String) value); return true;
            case "snapshotIsolationMode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotIsolationMode((java.lang.String) value); return true;
            case "snapshotLockingMode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotLockingMode((java.lang.String) value); return true;
            case "snapshotLockingModeCustomName": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotLockingModeCustomName((java.lang.String) value); return true;
            case "snapshotLockTimeoutMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotLockTimeoutMs((long) value); return true;
            case "snapshotMaxThreads": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotMaxThreads((int) value); return true;
            case "snapshotMode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotMode((java.lang.String) value); return true;
            case "snapshotModeConfigurationBasedSnapshotData": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotModeConfigurationBasedSnapshotData((boolean) value); return true;
            case "snapshotModeConfigurationBasedSnapshotOnDataError": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotModeConfigurationBasedSnapshotOnDataError((boolean) value); return true;
            case "snapshotModeConfigurationBasedSnapshotOnSchemaError": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotModeConfigurationBasedSnapshotOnSchemaError((boolean) value); return true;
            case "snapshotModeConfigurationBasedSnapshotSchema": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotModeConfigurationBasedSnapshotSchema((boolean) value); return true;
            case "snapshotModeConfigurationBasedStartStream": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotModeConfigurationBasedStartStream((boolean) value); return true;
            case "snapshotModeCustomName": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotModeCustomName((java.lang.String) value); return true;
            case "snapshotQueryMode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotQueryMode((java.lang.String) value); return true;
            case "snapshotQueryModeCustomName": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotQueryModeCustomName((java.lang.String) value); return true;
            case "snapshotSelectStatementOverrides": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotSelectStatementOverrides((java.lang.String) value); return true;
            case "snapshotTablesOrderByRowCount": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSnapshotTablesOrderByRowCount((java.lang.String) value); return true;
            case "sourceinfoStructMaker": getOrCreateConfiguration((DebeziumPostgresComponent) component).setSourceinfoStructMaker((java.lang.String) value); return true;
            case "statusUpdateIntervalMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setStatusUpdateIntervalMs((int) value); return true;
            case "streamingDelayMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setStreamingDelayMs((long) value); return true;
            case "tableExcludeList": getOrCreateConfiguration((DebeziumPostgresComponent) component).setTableExcludeList((java.lang.String) value); return true;
            case "tableIgnoreBuiltin": getOrCreateConfiguration((DebeziumPostgresComponent) component).setTableIgnoreBuiltin((boolean) value); return true;
            case "tableIncludeList": getOrCreateConfiguration((DebeziumPostgresComponent) component).setTableIncludeList((java.lang.String) value); return true;
            case "timePrecisionMode": getOrCreateConfiguration((DebeziumPostgresComponent) component).setTimePrecisionMode((java.lang.String) value); return true;
            case "tombstonesOnDelete": getOrCreateConfiguration((DebeziumPostgresComponent) component).setTombstonesOnDelete((boolean) value); return true;
            case "topicNamingStrategy": getOrCreateConfiguration((DebeziumPostgresComponent) component).setTopicNamingStrategy((java.lang.String) value); return true;
            case "topicPrefix": getOrCreateConfiguration((DebeziumPostgresComponent) component).setTopicPrefix((java.lang.String) value); return true;
            case "transactionMetadataFactory": getOrCreateConfiguration((DebeziumPostgresComponent) component).setTransactionMetadataFactory((java.lang.String) value); return true;
            case "unavailableValuePlaceholder": getOrCreateConfiguration((DebeziumPostgresComponent) component).setUnavailableValuePlaceholder((java.lang.String) value); return true;
            case "xminFetchIntervalMs": getOrCreateConfiguration((DebeziumPostgresComponent) component).setXminFetchIntervalMs((long) value); return true;
            default: return false;
            }
        }
    }
}