/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.engine.impl.TransportSender;

public class SenderImpl
extends LinkImpl
implements Sender {
    private int _offered;
    private TransportSender _transportLink;

    SenderImpl(SessionImpl session, String name) {
        super(session, name);
    }

    @Override
    public void offer(int credits) {
        this._offered = credits;
    }

    @Override
    public int send(byte[] bytes, int offset, int length) {
        if (this.getLocalState() == EndpointState.CLOSED) {
            throw new IllegalStateException("send not allowed after the sender is closed.");
        }
        DeliveryImpl current = this.current();
        if (current == null || current.getLink() != this) {
            throw new IllegalArgumentException();
        }
        int sent = current.send(bytes, offset, length);
        if (sent > 0) {
            this.getSession().incrementOutgoingBytes(sent);
        }
        return sent;
    }

    @Override
    public int send(ReadableBuffer buffer) {
        if (this.getLocalState() == EndpointState.CLOSED) {
            throw new IllegalStateException("send not allowed after the sender is closed.");
        }
        DeliveryImpl current = this.current();
        if (current == null || current.getLink() != this) {
            throw new IllegalArgumentException();
        }
        int sent = current.send(buffer);
        if (sent > 0) {
            this.getSession().incrementOutgoingBytes(sent);
        }
        return sent;
    }

    @Override
    public int sendNoCopy(ReadableBuffer buffer) {
        if (this.getLocalState() == EndpointState.CLOSED) {
            throw new IllegalStateException("send not allowed after the sender is closed.");
        }
        DeliveryImpl current = this.current();
        if (current == null || current.getLink() != this) {
            throw new IllegalArgumentException();
        }
        int sent = current.sendNoCopy(buffer);
        if (sent > 0) {
            this.getSession().incrementOutgoingBytes(sent);
        }
        return sent;
    }

    @Override
    public void abort() {
    }

    @Override
    void doFree() {
        this.getSession().freeSender(this);
        super.doFree();
    }

    @Override
    public boolean advance() {
        boolean advance;
        DeliveryImpl delivery = this.current();
        if (delivery != null) {
            delivery.setComplete();
        }
        if ((advance = super.advance()) && this._offered > 0) {
            --this._offered;
        }
        if (advance) {
            this.decrementCredit();
            delivery.addToTransportWorkList();
            this.getSession().incrementOutgoingDeliveries(1);
        }
        return advance;
    }

    boolean hasOfferedCredits() {
        return this._offered > 0;
    }

    @Override
    TransportSender getTransportLink() {
        return this._transportLink;
    }

    void setTransportLink(TransportSender transportLink) {
        this._transportLink = transportLink;
    }

    @Override
    public void setCredit(int credit) {
        super.setCredit(credit);
    }

    @Override
    public int getRemoteCredit() {
        return this.getCredit();
    }
}

