/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.service.annotation.HttpExchange;
import org.springframework.web.servlet.handler.MatchableHandlerMapping;
import org.springframework.web.servlet.handler.RequestMatchResult;
import org.springframework.web.servlet.mvc.condition.ConsumesRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.pattern.PathPatternParser;

public class RequestMappingHandlerMapping
extends RequestMappingInfoHandlerMapping
implements MatchableHandlerMapping,
EmbeddedValueResolverAware {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final RequestMethod[] EMPTY_REQUEST_METHOD_ARRAY = new RequestMethod[0];
    private boolean defaultPatternParser = true;
    private boolean useSuffixPatternMatch = false;
    private boolean useRegisteredSuffixPatternMatch = false;
    private boolean useTrailingSlashMatch = false;
    private Map<String, Predicate<Class<?>>> pathPrefixes = Collections.emptyMap();
    private ContentNegotiationManager contentNegotiationManager = new ContentNegotiationManager();
    @Nullable
    private StringValueResolver embeddedValueResolver;
    private RequestMappingInfo.BuilderConfiguration config = new RequestMappingInfo.BuilderConfiguration();

    @Override
    public void setPatternParser(@Nullable PathPatternParser patternParser) {
        if (patternParser != null) {
            this.defaultPatternParser = false;
        }
        super.setPatternParser(patternParser);
    }

    @Deprecated
    public void setUseSuffixPatternMatch(boolean useSuffixPatternMatch) {
        this.useSuffixPatternMatch = useSuffixPatternMatch;
    }

    @Deprecated
    public void setUseRegisteredSuffixPatternMatch(boolean useRegisteredSuffixPatternMatch) {
        this.useRegisteredSuffixPatternMatch = useRegisteredSuffixPatternMatch;
        this.useSuffixPatternMatch = useRegisteredSuffixPatternMatch || this.useSuffixPatternMatch;
    }

    @Deprecated(since="6.0")
    public void setUseTrailingSlashMatch(boolean useTrailingSlashMatch) {
        this.useTrailingSlashMatch = useTrailingSlashMatch;
        if (this.getPatternParser() != null) {
            this.getPatternParser().setMatchOptionalTrailingSeparator(useTrailingSlashMatch);
        }
    }

    public void setPathPrefixes(Map<String, Predicate<Class<?>>> prefixes) {
        this.pathPrefixes = !prefixes.isEmpty() ? Collections.unmodifiableMap(new LinkedHashMap(prefixes)) : Collections.emptyMap();
    }

    public Map<String, Predicate<Class<?>>> getPathPrefixes() {
        return this.pathPrefixes;
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        Assert.notNull((Object)contentNegotiationManager, (String)"ContentNegotiationManager must not be null");
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Override
    public void afterPropertiesSet() {
        this.config = new RequestMappingInfo.BuilderConfiguration();
        this.config.setTrailingSlashMatch(this.useTrailingSlashMatch());
        this.config.setContentNegotiationManager(this.getContentNegotiationManager());
        if (this.getPatternParser() != null && this.defaultPatternParser && (this.useSuffixPatternMatch || this.useRegisteredSuffixPatternMatch)) {
            this.setPatternParser(null);
        }
        if (this.getPatternParser() != null) {
            this.config.setPatternParser(this.getPatternParser());
            Assert.isTrue((!this.useSuffixPatternMatch && !this.useRegisteredSuffixPatternMatch ? 1 : 0) != 0, (String)"Suffix pattern matching not supported with PathPatternParser.");
        } else {
            this.config.setSuffixPatternMatch(this.useSuffixPatternMatch());
            this.config.setRegisteredSuffixPatternMatch(this.useRegisteredSuffixPatternMatch());
            this.config.setPathMatcher(this.getPathMatcher());
        }
        super.afterPropertiesSet();
    }

    @Deprecated
    public boolean useSuffixPatternMatch() {
        return this.useSuffixPatternMatch;
    }

    @Deprecated
    public boolean useRegisteredSuffixPatternMatch() {
        return this.useRegisteredSuffixPatternMatch;
    }

    public boolean useTrailingSlashMatch() {
        return this.useTrailingSlashMatch;
    }

    @Nullable
    @Deprecated
    public List<String> getFileExtensions() {
        return this.config.getFileExtensions();
    }

    public RequestMappingInfo.BuilderConfiguration getBuilderConfiguration() {
        return this.config;
    }

    @Override
    protected boolean isHandler(Class<?> beanType) {
        return AnnotatedElementUtils.hasAnnotation(beanType, Controller.class);
    }

    @Override
    @Nullable
    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo info = this.createRequestMappingInfo(method);
        if (info != null) {
            String prefix;
            RequestMappingInfo typeInfo = this.createRequestMappingInfo(handlerType);
            if (typeInfo != null) {
                info = typeInfo.combine(info);
            }
            if (info.isEmptyMapping()) {
                info = info.mutate().paths("", "/").options(this.config).build();
            }
            if ((prefix = this.getPathPrefix(handlerType)) != null) {
                info = RequestMappingInfo.paths(prefix).options(this.config).build().combine(info);
            }
        }
        return info;
    }

    @Nullable
    String getPathPrefix(Class<?> handlerType) {
        for (Map.Entry<String, Predicate<Class<?>>> entry : this.pathPrefixes.entrySet()) {
            if (!entry.getValue().test(handlerType)) continue;
            String prefix = entry.getKey();
            if (this.embeddedValueResolver != null) {
                prefix = this.embeddedValueResolver.resolveStringValue(prefix);
            }
            return prefix;
        }
        return null;
    }

    @Nullable
    private RequestMappingInfo createRequestMappingInfo(AnnotatedElement element) {
        List<AnnotationDescriptor> httpExchanges;
        RequestCondition<?> requestCondition;
        RequestMappingInfo requestMappingInfo = null;
        if (element instanceof Class) {
            Class clazz = (Class)element;
            requestCondition = this.getCustomTypeCondition(clazz);
        } else {
            requestCondition = this.getCustomMethodCondition((Method)element);
        }
        RequestCondition<?> customCondition = requestCondition;
        List<AnnotationDescriptor> descriptors = RequestMappingHandlerMapping.getAnnotationDescriptors(element);
        List<AnnotationDescriptor> requestMappings = descriptors.stream().filter(desc -> desc.annotation instanceof RequestMapping).toList();
        if (!requestMappings.isEmpty()) {
            if (requestMappings.size() > 1 && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Multiple @RequestMapping annotations found on %s, but only the first will be used: %s".formatted(element, requestMappings));
            }
            requestMappingInfo = this.createRequestMappingInfo((RequestMapping)requestMappings.get((int)0).annotation, customCondition);
        }
        if (!(httpExchanges = descriptors.stream().filter(desc -> desc.annotation instanceof HttpExchange).toList()).isEmpty()) {
            Assert.state((requestMappingInfo == null ? 1 : 0) != 0, () -> "%s is annotated with @RequestMapping and @HttpExchange annotations, but only one is allowed: %s".formatted(element, Stream.of(requestMappings, httpExchanges).flatMap(Collection::stream).toList()));
            Assert.state((httpExchanges.size() == 1 ? 1 : 0) != 0, () -> "Multiple @HttpExchange annotations found on %s, but only one is allowed: %s".formatted(element, httpExchanges));
            requestMappingInfo = this.createRequestMappingInfo((HttpExchange)httpExchanges.get((int)0).annotation, customCondition);
        }
        return requestMappingInfo;
    }

    @Nullable
    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        return null;
    }

    @Nullable
    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        return null;
    }

    protected RequestMappingInfo createRequestMappingInfo(RequestMapping requestMapping, @Nullable RequestCondition<?> customCondition) {
        RequestMappingInfo.Builder builder = RequestMappingInfo.paths(this.resolveEmbeddedValuesInPatterns(requestMapping.path())).methods(requestMapping.method()).params(requestMapping.params()).headers(requestMapping.headers()).consumes(requestMapping.consumes()).produces(requestMapping.produces()).mappingName(requestMapping.name());
        if (customCondition != null) {
            builder.customCondition(customCondition);
        }
        return builder.options(this.config).build();
    }

    protected RequestMappingInfo createRequestMappingInfo(HttpExchange httpExchange, @Nullable RequestCondition<?> customCondition) {
        RequestMappingInfo.Builder builder = RequestMappingInfo.paths(this.resolveEmbeddedValuesInPatterns(RequestMappingHandlerMapping.toStringArray(httpExchange.value()))).methods(RequestMappingHandlerMapping.toMethodArray(httpExchange.method())).consumes(RequestMappingHandlerMapping.toStringArray(httpExchange.contentType())).produces(httpExchange.accept()).headers(httpExchange.headers());
        if (customCondition != null) {
            builder.customCondition(customCondition);
        }
        return builder.options(this.config).build();
    }

    protected String[] resolveEmbeddedValuesInPatterns(String[] patterns) {
        if (this.embeddedValueResolver == null) {
            return patterns;
        }
        String[] resolvedPatterns = new String[patterns.length];
        for (int i2 = 0; i2 < patterns.length; ++i2) {
            resolvedPatterns[i2] = this.embeddedValueResolver.resolveStringValue(patterns[i2]);
        }
        return resolvedPatterns;
    }

    private static String[] toStringArray(String value) {
        String[] stringArray;
        if (StringUtils.hasText((String)value)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        } else {
            stringArray = EMPTY_STRING_ARRAY;
        }
        return stringArray;
    }

    private static RequestMethod[] toMethodArray(String method) {
        RequestMethod[] requestMethodArray;
        if (StringUtils.hasText((String)method)) {
            RequestMethod[] requestMethodArray2 = new RequestMethod[1];
            requestMethodArray = requestMethodArray2;
            requestMethodArray2[0] = RequestMethod.valueOf((String)method);
        } else {
            requestMethodArray = EMPTY_REQUEST_METHOD_ARRAY;
        }
        return requestMethodArray;
    }

    @Override
    public void registerMapping(RequestMappingInfo mapping, Object handler, Method method) {
        super.registerMapping(mapping, handler, method);
        this.updateConsumesCondition(mapping, method);
    }

    @Override
    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        super.registerHandlerMethod(handler, method, mapping);
        this.updateConsumesCondition(mapping, method);
    }

    private void updateConsumesCondition(RequestMappingInfo info, Method method) {
        ConsumesRequestCondition condition = info.getConsumesCondition();
        if (!condition.isEmpty()) {
            for (Parameter parameter : method.getParameters()) {
                MergedAnnotation annot = MergedAnnotations.from((AnnotatedElement)parameter).get(RequestBody.class);
                if (!annot.isPresent()) continue;
                condition.setBodyRequired(annot.getBoolean("required"));
                break;
            }
        }
    }

    @Override
    @Nullable
    public RequestMatchResult match(HttpServletRequest request, String pattern) {
        Assert.state((this.getPatternParser() == null ? 1 : 0) != 0, (String)"This HandlerMapping uses PathPatterns.");
        RequestMappingInfo info = RequestMappingInfo.paths(pattern).options(this.config).build();
        RequestMappingInfo match = info.getMatchingCondition(request);
        return match != null && match.getPatternsCondition() != null ? new RequestMatchResult(match.getPatternsCondition().getPatterns().iterator().next(), UrlPathHelper.getResolvedLookupPath((ServletRequest)request), this.getPathMatcher()) : null;
    }

    @Override
    @Nullable
    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mappingInfo) {
        HandlerMethod handlerMethod = this.createHandlerMethod(handler, method);
        Class beanType = handlerMethod.getBeanType();
        CrossOrigin typeAnnotation = (CrossOrigin)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)beanType, CrossOrigin.class);
        CrossOrigin methodAnnotation = (CrossOrigin)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, CrossOrigin.class);
        if (typeAnnotation == null && methodAnnotation == null) {
            return null;
        }
        CorsConfiguration config = new CorsConfiguration();
        this.updateCorsConfig(config, typeAnnotation);
        this.updateCorsConfig(config, methodAnnotation);
        if (CollectionUtils.isEmpty((Collection)config.getAllowedMethods())) {
            for (RequestMethod allowedMethod : mappingInfo.getMethodsCondition().getMethods()) {
                config.addAllowedMethod(allowedMethod.name());
            }
        }
        return config.applyPermitDefaultValues();
    }

    private void updateCorsConfig(CorsConfiguration config, @Nullable CrossOrigin annotation) {
        if (annotation == null) {
            return;
        }
        for (String string : annotation.origins()) {
            config.addAllowedOrigin(this.resolveCorsAnnotationValue(string));
        }
        for (String string : annotation.originPatterns()) {
            config.addAllowedOriginPattern(this.resolveCorsAnnotationValue(string));
        }
        for (String string : annotation.methods()) {
            config.addAllowedMethod(string.name());
        }
        for (String string : annotation.allowedHeaders()) {
            config.addAllowedHeader(this.resolveCorsAnnotationValue(string));
        }
        for (String string : annotation.exposedHeaders()) {
            config.addExposedHeader(this.resolveCorsAnnotationValue(string));
        }
        String allowCredentials = this.resolveCorsAnnotationValue(annotation.allowCredentials());
        if ("true".equalsIgnoreCase(allowCredentials)) {
            config.setAllowCredentials(Boolean.valueOf(true));
        } else if ("false".equalsIgnoreCase(allowCredentials)) {
            config.setAllowCredentials(Boolean.valueOf(false));
        } else if (!allowCredentials.isEmpty()) {
            throw new IllegalStateException("@CrossOrigin's allowCredentials value must be \"true\", \"false\", or an empty string (\"\"): current value is [" + allowCredentials + "]");
        }
        String allowPrivateNetwork = this.resolveCorsAnnotationValue(annotation.allowPrivateNetwork());
        if ("true".equalsIgnoreCase(allowPrivateNetwork)) {
            config.setAllowPrivateNetwork(Boolean.valueOf(true));
        } else if ("false".equalsIgnoreCase(allowPrivateNetwork)) {
            config.setAllowPrivateNetwork(Boolean.valueOf(false));
        } else if (!allowPrivateNetwork.isEmpty()) {
            throw new IllegalStateException("@CrossOrigin's allowPrivateNetwork value must be \"true\", \"false\", or an empty string (\"\"): current value is [" + allowPrivateNetwork + "]");
        }
        if (annotation.maxAge() >= 0L) {
            config.setMaxAge(Long.valueOf(annotation.maxAge()));
        }
    }

    private String resolveCorsAnnotationValue(String value) {
        if (this.embeddedValueResolver != null) {
            String resolved = this.embeddedValueResolver.resolveStringValue(value);
            return resolved != null ? resolved : "";
        }
        return value;
    }

    private static List<AnnotationDescriptor> getAnnotationDescriptors(AnnotatedElement element) {
        return MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, (RepeatableContainers)RepeatableContainers.none()).stream().filter(MergedAnnotationPredicates.typeIn((Class[])new Class[]{RequestMapping.class, HttpExchange.class})).filter(MergedAnnotationPredicates.firstRunOf(MergedAnnotation::getAggregateIndex)).map(AnnotationDescriptor::new).distinct().toList();
    }

    private static class AnnotationDescriptor {
        private final Annotation annotation;
        private final MergedAnnotation<?> root;

        AnnotationDescriptor(MergedAnnotation<Annotation> mergedAnnotation) {
            this.annotation = mergedAnnotation.synthesize();
            this.root = mergedAnnotation.getRoot();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof AnnotationDescriptor)) return false;
            AnnotationDescriptor that = (AnnotationDescriptor)obj;
            if (!this.annotation.equals(that.annotation)) return false;
            return true;
        }

        public int hashCode() {
            return this.annotation.hashCode();
        }

        public String toString() {
            return this.root.synthesize().toString();
        }
    }
}

