/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;

public class BlockingQueueTransport
extends TransportSupport {
    public static final long MAX_TIMEOUT = 30000L;
    private BlockingQueue<Object> queue;

    public BlockingQueueTransport(BlockingQueue<Object> channel) {
        this.queue = channel;
    }

    public BlockingQueue<Object> getQueue() {
        return this.queue;
    }

    public void oneway(Object command) throws IOException {
        try {
            boolean success = this.queue.offer(command, 30000L, TimeUnit.MILLISECONDS);
            if (!success) {
                throw new IOException("Fail to add to BlockingQueue. Add timed out after 30000ms: size=" + this.queue.size());
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Fail to add to BlockingQueue. Interrupted while waiting for space: size=" + this.queue.size());
        }
    }

    public String getRemoteAddress() {
        return "blockingQueue_" + this.queue.hashCode();
    }

    protected void doStart() throws Exception {
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
    }

    public int getReceiveCounter() {
        return 0;
    }

    public X509Certificate[] getPeerCertificates() {
        return null;
    }

    public void setPeerCertificates(X509Certificate[] certificates) {
    }

    public WireFormat getWireFormat() {
        return null;
    }
}

