/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpLogging;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.user.SimpSession;
import org.springframework.messaging.simp.user.SimpUser;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.messaging.simp.user.UserDestinationResult;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultUserDestinationResolver
implements UserDestinationResolver {
    private static final Log logger = SimpLogging.forLogName(DefaultUserDestinationResolver.class);
    private final SimpUserRegistry userRegistry;
    private String prefix = "/user/";
    private boolean removeLeadingSlash = false;

    public DefaultUserDestinationResolver(SimpUserRegistry userRegistry) {
        Assert.notNull((Object)userRegistry, "SimpUserRegistry must not be null");
        this.userRegistry = userRegistry;
    }

    public SimpUserRegistry getSimpUserRegistry() {
        return this.userRegistry;
    }

    public void setUserDestinationPrefix(String prefix) {
        Assert.hasText(prefix, "Prefix must not be empty");
        this.prefix = prefix.endsWith("/") ? prefix : prefix + "/";
    }

    public String getDestinationPrefix() {
        return this.prefix;
    }

    public void setRemoveLeadingSlash(boolean remove) {
        this.removeLeadingSlash = remove;
    }

    public boolean isRemoveLeadingSlash() {
        return this.removeLeadingSlash;
    }

    @Override
    @Nullable
    public UserDestinationResult resolveDestination(Message<?> message) {
        ParseResult parseResult = this.parse(message);
        if (parseResult == null) {
            return null;
        }
        String user = parseResult.getUser();
        String sourceDest = parseResult.getSourceDestination();
        Set<String> sessionIds = parseResult.getSessionIds();
        HashSet<String> targetSet = new HashSet<String>();
        for (String sessionId : sessionIds) {
            String actualDest = parseResult.getActualDestination();
            String targetDest = this.getTargetDestination(sourceDest, actualDest, sessionId, user);
            if (targetDest == null) continue;
            targetSet.add(targetDest);
        }
        String subscribeDest = parseResult.getSubscribeDestination();
        return new UserDestinationResult(sourceDest, targetSet, subscribeDest, user, sessionIds);
    }

    @Nullable
    private ParseResult parse(Message<?> message) {
        MessageHeaders headers = message.getHeaders();
        String sourceDestination = SimpMessageHeaderAccessor.getDestination(headers);
        if (sourceDestination == null || !this.checkDestination(sourceDestination, this.prefix)) {
            return null;
        }
        SimpMessageType messageType = SimpMessageHeaderAccessor.getMessageType(headers);
        if (messageType != null) {
            return switch (messageType) {
                case SimpMessageType.SUBSCRIBE, SimpMessageType.UNSUBSCRIBE -> this.parseSubscriptionMessage(message, sourceDestination);
                case SimpMessageType.MESSAGE -> this.parseMessage(headers, sourceDestination);
                default -> null;
            };
        }
        return null;
    }

    @Nullable
    private ParseResult parseSubscriptionMessage(Message<?> message, String sourceDestination) {
        Principal principal;
        MessageHeaders headers = message.getHeaders();
        String sessionId = SimpMessageHeaderAccessor.getSessionId(headers);
        if (sessionId == null) {
            logger.error((Object)("No session id. Ignoring " + String.valueOf(message)));
            return null;
        }
        int prefixEnd = this.prefix.length() - 1;
        String actualDestination = sourceDestination.substring(prefixEnd);
        if (this.isRemoveLeadingSlash()) {
            actualDestination = actualDestination.substring(1);
        }
        String user = (principal = SimpMessageHeaderAccessor.getUser(headers)) != null ? principal.getName() : null;
        Assert.isTrue(user == null || !user.contains("%2F"), () -> "Invalid sequence \"%2F\" in user name: " + user);
        Set<String> sessionIds = Collections.singleton(sessionId);
        return new ParseResult(sourceDestination, actualDestination, sourceDestination, sessionIds, user);
    }

    private ParseResult parseMessage(MessageHeaders headers, String sourceDest) {
        Set<String> sessionIds;
        int prefixEnd = this.prefix.length();
        int userEnd = sourceDest.indexOf(47, prefixEnd);
        Assert.isTrue(userEnd > 0, "Expected destination pattern \"/user/{userId}/**\"");
        String actualDest = sourceDest.substring(userEnd);
        String subscribeDest = this.prefix.substring(0, prefixEnd - 1) + actualDest;
        String userName = sourceDest.substring(prefixEnd, userEnd);
        userName = StringUtils.replace(userName, "%2F", "/");
        String sessionId = SimpMessageHeaderAccessor.getSessionId(headers);
        if (userName.equals(sessionId)) {
            userName = null;
            sessionIds = Collections.singleton(sessionId);
        } else {
            sessionIds = this.getSessionIdsByUser(userName, sessionId);
        }
        if (this.isRemoveLeadingSlash()) {
            actualDest = actualDest.substring(1);
        }
        return new ParseResult(sourceDest, actualDest, subscribeDest, sessionIds, userName);
    }

    private Set<String> getSessionIdsByUser(String userName, @Nullable String sessionId) {
        Set<String> sessionIds;
        SimpUser user = this.userRegistry.getUser(userName);
        if (user != null) {
            if (sessionId != null && user.getSession(sessionId) != null) {
                sessionIds = Collections.singleton(sessionId);
            } else {
                Set<SimpSession> sessions = user.getSessions();
                sessionIds = CollectionUtils.newHashSet(sessions.size());
                for (SimpSession session : sessions) {
                    sessionIds.add(session.getId());
                }
            }
        } else {
            sessionIds = Collections.emptySet();
        }
        return sessionIds;
    }

    protected boolean checkDestination(String destination, String requiredPrefix) {
        return destination.startsWith(requiredPrefix);
    }

    @Nullable
    protected String getTargetDestination(String sourceDestination, String actualDestination, String sessionId, @Nullable String user) {
        return actualDestination + "-user" + sessionId;
    }

    public String toString() {
        return "DefaultUserDestinationResolver[prefix=" + this.prefix + "]";
    }

    private static class ParseResult {
        private final String sourceDestination;
        private final String actualDestination;
        private final String subscribeDestination;
        private final Set<String> sessionIds;
        @Nullable
        private final String user;

        public ParseResult(String sourceDest, String actualDest, String subscribeDest, Set<String> sessionIds, @Nullable String user) {
            this.sourceDestination = sourceDest;
            this.actualDestination = actualDest;
            this.subscribeDestination = subscribeDest;
            this.sessionIds = sessionIds;
            this.user = user;
        }

        public String getSourceDestination() {
            return this.sourceDestination;
        }

        public String getActualDestination() {
            return this.actualDestination;
        }

        public String getSubscribeDestination() {
            return this.subscribeDestination;
        }

        public Set<String> getSessionIds() {
            return this.sessionIds;
        }

        @Nullable
        public String getUser() {
            return this.user;
        }
    }
}

