/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.Stomp;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompFrameError;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.DataByteArrayInputStream;

public class StompCodec {
    static final byte[] crlfcrlf = new byte[]{13, 10, 13, 10};
    TcpTransport transport;
    StompWireFormat wireFormat;
    AtomicLong frameSize = new AtomicLong();
    ByteArrayOutputStream currentCommand = new ByteArrayOutputStream();
    boolean processedHeaders = false;
    String action;
    HashMap<String, String> headers;
    int contentLength = -1;
    int readLength = 0;
    int previousByte = -1;
    boolean awaitingCommandStart = true;
    String version = "1.0";

    public StompCodec(TcpTransport transport) {
        this.transport = transport;
        this.wireFormat = (StompWireFormat)transport.getWireFormat();
    }

    public void parse(ByteArrayInputStream input, int readSize) throws Exception {
        int i2 = 0;
        while (i2++ < readSize) {
            int b = input.read();
            if (!this.processedHeaders && this.previousByte == 0 && b == 0) continue;
            if (!this.processedHeaders) {
                if (this.awaitingCommandStart && b == 10) continue;
                this.awaitingCommandStart = false;
                this.currentCommand.write(b);
                if (b == 10 && (this.previousByte == 10 || this.currentCommand.endsWith(crlfcrlf))) {
                    DataByteArrayInputStream data = new DataByteArrayInputStream(this.currentCommand.toByteArray());
                    try {
                        this.action = this.wireFormat.parseAction(data, this.frameSize);
                        this.headers = this.wireFormat.parseHeaders(data, this.frameSize);
                        String contentLengthHeader = this.headers.get("content-length");
                        this.contentLength = (this.action.equals("SEND") || this.action.equals("MESSAGE")) && contentLengthHeader != null ? this.wireFormat.parseContentLength(contentLengthHeader, this.frameSize) : -1;
                    }
                    catch (ProtocolException e) {
                        this.transport.doConsume(new StompFrameError(e));
                        return;
                    }
                    this.processedHeaders = true;
                    this.currentCommand.reset();
                }
            } else if (this.contentLength == -1) {
                if (b == 0) {
                    this.processCommand();
                } else {
                    StompFrameError errorFrame;
                    this.currentCommand.write(b);
                    if (this.currentCommand.size() > this.wireFormat.getMaxDataLength()) {
                        errorFrame = new StompFrameError(new ProtocolException("The maximum data length was exceeded", true));
                        errorFrame.setAction(this.action);
                        this.transport.doConsume(errorFrame);
                        return;
                    }
                    if (this.frameSize.incrementAndGet() > this.wireFormat.getMaxFrameSize()) {
                        errorFrame = new StompFrameError(new ProtocolException("The maximum frame size was exceeded", true));
                        errorFrame.setAction(this.action);
                        this.transport.doConsume(errorFrame);
                        return;
                    }
                }
            } else if (this.readLength++ == this.contentLength) {
                this.processCommand();
                this.readLength = 0;
            } else {
                this.currentCommand.write(b);
            }
            this.previousByte = b;
        }
    }

    protected void processCommand() throws Exception {
        StompFrame frame = new StompFrame(this.action, this.headers, this.currentCommand.toByteArray());
        this.transport.doConsume(frame);
        this.processedHeaders = false;
        this.awaitingCommandStart = true;
        this.currentCommand.reset();
        this.contentLength = -1;
        this.frameSize.set(0L);
    }

    public static String detectVersion(Map<String, String> headers) throws ProtocolException {
        String accepts = headers.get("accept-version");
        if (accepts == null) {
            accepts = "1.0";
        }
        HashSet<String> acceptsVersions = new HashSet<String>(Arrays.asList(accepts.trim().split(",")));
        acceptsVersions.retainAll(Arrays.asList(Stomp.SUPPORTED_PROTOCOL_VERSIONS));
        if (acceptsVersions.isEmpty()) {
            throw new ProtocolException("Invalid Protocol version[" + accepts + "], supported versions are: " + Arrays.toString(Stomp.SUPPORTED_PROTOCOL_VERSIONS), true);
        }
        return Collections.max(acceptsVersions);
    }
}

