/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.processor.loadbalancer.DistributionRatio;
import org.apache.camel.processor.loadbalancer.WeightedLoadBalancer;

public class WeightedRoundRobinLoadBalancer
extends WeightedLoadBalancer {
    int counter = -1;

    public WeightedRoundRobinLoadBalancer(List<Integer> distributionRatios) {
        super(distributionRatios);
    }

    @Override
    protected AsyncProcessor chooseProcessor(AsyncProcessor[] processors, Exchange exchange) {
        this.lock.lock();
        try {
            int counter = this.counter;
            List<DistributionRatio> ratios = this.getRatios();
            while (true) {
                DistributionRatio ratio;
                if (++counter >= ratios.size()) {
                    counter = 0;
                }
                if (!(ratio = ratios.get(counter)).decrement()) continue;
                this.counter = this.lastIndex = counter;
                this.decrementSum();
                AsyncProcessor asyncProcessor = processors[counter];
                return asyncProcessor;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.counter = -1;
    }
}

