/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.JMSException;
import jakarta.jms.XAConnection;
import jakarta.jms.XAConnectionFactory;
import jakarta.jms.XAJMSContext;
import jakarta.jms.XAQueueConnection;
import jakarta.jms.XAQueueConnectionFactory;
import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicConnectionFactory;
import java.net.URI;
import java.util.Properties;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.ActiveMQXAConnection;
import org.apache.activemq.ActiveMQXAContext;
import org.apache.activemq.management.JMSStatsImpl;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.util.JMSExceptionSupport;

public class ActiveMQXASslConnectionFactory
extends ActiveMQSslConnectionFactory
implements XAConnectionFactory,
XAQueueConnectionFactory,
XATopicConnectionFactory {
    public ActiveMQXASslConnectionFactory() {
    }

    public ActiveMQXASslConnectionFactory(String brokerURL) {
        super(brokerURL);
    }

    public ActiveMQXASslConnectionFactory(URI brokerURL) {
        super(brokerURL);
    }

    public XAConnection createXAConnection() throws JMSException {
        return (XAConnection)this.createActiveMQConnection();
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        return (XAConnection)this.createActiveMQConnection(userName, password);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return (XAQueueConnection)this.createActiveMQConnection();
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        return (XAQueueConnection)this.createActiveMQConnection(userName, password);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return (XATopicConnection)this.createActiveMQConnection();
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        return (XATopicConnection)this.createActiveMQConnection(userName, password);
    }

    public XAJMSContext createXAContext() {
        try {
            return new ActiveMQXAContext((ActiveMQXAConnection)this.createXAConnection());
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    public XAJMSContext createXAContext(String userName, String password) {
        try {
            return new ActiveMQXAContext((ActiveMQXAConnection)this.createXAConnection(userName, password));
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    protected ActiveMQConnection createActiveMQConnection(Transport transport, JMSStatsImpl stats) throws Exception {
        ActiveMQXAConnection connection = new ActiveMQXAConnection(transport, this.getClientIdGenerator(), this.getConnectionIdGenerator(), stats);
        this.configureXAConnection(connection);
        return connection;
    }

    private void configureXAConnection(ActiveMQXAConnection connection) {
        connection.setXaAckMode(this.xaAckMode);
    }

    public int getXaAckMode() {
        return this.xaAckMode;
    }

    public void setXaAckMode(int xaAckMode) {
        this.xaAckMode = xaAckMode;
    }

    @Override
    public void populateProperties(Properties props) {
        super.populateProperties(props);
        props.put("xaAckMode", Integer.toString(this.xaAckMode));
    }
}

