/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.ContentTypeHeaderAware;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.spi.Metadata;

@Metadata(label="dataformat,transformation,json", title="JSon")
@XmlRootElement(name="json")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JsonDataFormat
extends DataFormatDefinition
implements ContentTypeHeaderAware {
    @XmlAttribute
    private String objectMapper;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    private String useDefaultObjectMapper;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="false")
    private String autoDiscoverObjectMapper;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String prettyPrint;
    @XmlAttribute
    @Metadata(defaultValue="Jackson")
    private JsonLibrary library = JsonLibrary.Jackson;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", description="Force generator that outputs JSON content to combine surrogate pairs (if any) into 4-byte characters. This should be preferred when using 4-byte characters such as Japanese.")
    private String combineUnicodeSurrogates;
    @XmlAttribute(name="unmarshalType")
    private String unmarshalTypeName;
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute(name="jsonView")
    @Metadata(label="advanced")
    private String jsonViewTypeName;
    @XmlTransient
    private Class<?> jsonView;
    @XmlAttribute
    @Metadata(label="advanced")
    private String include;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String allowJmsType;
    @XmlAttribute(name="collectionType")
    @Metadata(label="advanced")
    private String collectionTypeName;
    @XmlTransient
    private Class<?> collectionType;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String useList;
    @XmlAttribute
    @Metadata(label="advanced")
    private String moduleClassNames;
    @XmlAttribute
    @Metadata(label="advanced")
    private String moduleRefs;
    @XmlAttribute
    @Metadata(label="advanced")
    private String enableFeatures;
    @XmlAttribute
    @Metadata(label="advanced")
    private String disableFeatures;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String allowUnmarshallType;
    @XmlAttribute
    @Metadata(label="advanced")
    private String timezone;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.component.jackson.SchemaResolver")
    private String schemaResolver;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String autoDiscoverSchemaResolver;
    @XmlAttribute
    @Metadata(description="If set then Jackson will use the the defined Property Naming Strategy.Possible values are: LOWER_CAMEL_CASE, LOWER_DOT_CASE, LOWER_CASE, KEBAB_CASE, SNAKE_CASE and UPPER_CAMEL_CASE")
    private String namingStrategy;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true", description="Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON")
    private String contentTypeHeader;
    @XmlAttribute
    @Metadata(description="To configure the date format while marshall or unmarshall Date fields in JSON using Gson")
    private String dateFormatPattern;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Integer")
    private String maxStringLength;

    public JsonDataFormat() {
        super("json");
    }

    public JsonDataFormat(JsonLibrary library) {
        this();
        this.library = library;
    }

    protected JsonDataFormat(JsonDataFormat source) {
        super(source);
        this.objectMapper = source.objectMapper;
        this.useDefaultObjectMapper = source.useDefaultObjectMapper;
        this.autoDiscoverObjectMapper = source.autoDiscoverObjectMapper;
        this.prettyPrint = source.prettyPrint;
        this.library = source.library;
        this.combineUnicodeSurrogates = source.combineUnicodeSurrogates;
        this.unmarshalTypeName = source.unmarshalTypeName;
        this.unmarshalType = source.unmarshalType;
        this.jsonViewTypeName = source.jsonViewTypeName;
        this.jsonView = source.jsonView;
        this.include = source.include;
        this.allowJmsType = source.allowJmsType;
        this.collectionTypeName = source.collectionTypeName;
        this.collectionType = source.collectionType;
        this.useList = source.useList;
        this.moduleClassNames = source.moduleClassNames;
        this.moduleRefs = source.moduleRefs;
        this.enableFeatures = source.enableFeatures;
        this.disableFeatures = source.disableFeatures;
        this.allowUnmarshallType = source.allowUnmarshallType;
        this.timezone = source.timezone;
        this.schemaResolver = source.schemaResolver;
        this.autoDiscoverSchemaResolver = source.autoDiscoverSchemaResolver;
        this.namingStrategy = source.namingStrategy;
        this.contentTypeHeader = source.contentTypeHeader;
        this.dateFormatPattern = source.dateFormatPattern;
        this.maxStringLength = source.maxStringLength;
    }

    private JsonDataFormat(Builder builder) {
        this();
        this.objectMapper = builder.objectMapper;
        this.useDefaultObjectMapper = builder.useDefaultObjectMapper;
        this.autoDiscoverObjectMapper = builder.autoDiscoverObjectMapper;
        this.prettyPrint = builder.prettyPrint;
        this.library = builder.library;
        this.combineUnicodeSurrogates = builder.combineUnicodeSurrogates;
        this.unmarshalTypeName = builder.unmarshalTypeName;
        this.unmarshalType = builder.unmarshalType;
        this.jsonViewTypeName = builder.jsonViewTypeName;
        this.jsonView = builder.jsonView;
        this.include = builder.include;
        this.allowJmsType = builder.allowJmsType;
        this.collectionTypeName = builder.collectionTypeName;
        this.collectionType = builder.collectionType;
        this.useList = builder.useList;
        this.moduleClassNames = builder.moduleClassNames;
        this.moduleRefs = builder.moduleRefs;
        this.enableFeatures = builder.enableFeatures;
        this.disableFeatures = builder.disableFeatures;
        this.allowUnmarshallType = builder.allowUnmarshallType;
        this.timezone = builder.timezone;
        this.schemaResolver = builder.schemaResolver;
        this.autoDiscoverSchemaResolver = builder.autoDiscoverSchemaResolver;
        this.namingStrategy = builder.namingStrategy;
        this.contentTypeHeader = builder.contentTypeHeader;
        this.dateFormatPattern = builder.dateFormatPattern;
        this.maxStringLength = builder.maxStringLength;
    }

    @Override
    public JsonDataFormat copyDefinition() {
        return new JsonDataFormat(this);
    }

    @Override
    public String getDataFormatName() {
        return this.library.getDataFormatName();
    }

    @Override
    public String getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public void setContentTypeHeader(String contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public String getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(String objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String getUseDefaultObjectMapper() {
        return this.useDefaultObjectMapper;
    }

    public void setUseDefaultObjectMapper(String useDefaultObjectMapper) {
        this.useDefaultObjectMapper = useDefaultObjectMapper;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(String prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getCombineUnicodeSurrogates() {
        return this.combineUnicodeSurrogates;
    }

    public void setCombineUnicodeSurrogates(String combineUnicodeSurrogates) {
        this.combineUnicodeSurrogates = combineUnicodeSurrogates;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public JsonLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(JsonLibrary library) {
        this.library = library;
    }

    public String getJsonViewTypeName() {
        return this.jsonViewTypeName;
    }

    public void setJsonViewTypeName(String jsonViewTypeName) {
        this.jsonViewTypeName = jsonViewTypeName;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getAllowJmsType() {
        return this.allowJmsType;
    }

    public void setAllowJmsType(String allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    public String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Class<?> collectionType) {
        this.collectionType = collectionType;
    }

    public String getUseList() {
        return this.useList;
    }

    public void setUseList(String useList) {
        this.useList = useList;
    }

    public String getModuleClassNames() {
        return this.moduleClassNames;
    }

    public void setModuleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
    }

    public String getModuleRefs() {
        return this.moduleRefs;
    }

    public void setModuleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
    }

    public String getEnableFeatures() {
        return this.enableFeatures;
    }

    public void setEnableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public String getDisableFeatures() {
        return this.disableFeatures;
    }

    public void setDisableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
    }

    public String getAllowUnmarshallType() {
        return this.allowUnmarshallType;
    }

    public void setAllowUnmarshallType(String allowUnmarshallType) {
        this.allowUnmarshallType = allowUnmarshallType;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getAutoDiscoverObjectMapper() {
        return this.autoDiscoverObjectMapper;
    }

    public void setAutoDiscoverObjectMapper(String autoDiscoverObjectMapper) {
        this.autoDiscoverObjectMapper = autoDiscoverObjectMapper;
    }

    public void setSchemaResolver(String schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public String getSchemaResolver() {
        return this.schemaResolver;
    }

    public String getAutoDiscoverSchemaResolver() {
        return this.autoDiscoverSchemaResolver;
    }

    public void setAutoDiscoverSchemaResolver(String autoDiscoverSchemaResolver) {
        this.autoDiscoverSchemaResolver = autoDiscoverSchemaResolver;
    }

    public String getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(String namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public String getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(String maxStringLength) {
        this.maxStringLength = maxStringLength;
    }

    public JsonDataFormat objectMapper(String objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public JsonDataFormat useDefaultObjectMapper(boolean useDefaultObjectMapper) {
        return this.useDefaultObjectMapper(Boolean.toString(useDefaultObjectMapper));
    }

    public JsonDataFormat useDefaultObjectMapper(String useDefaultObjectMapper) {
        this.useDefaultObjectMapper = useDefaultObjectMapper;
        return this;
    }

    public JsonDataFormat prettyPrint(boolean prettyPrint) {
        return this.prettyPrint(Boolean.toString(prettyPrint));
    }

    public JsonDataFormat prettyPrint(String prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    public JsonDataFormat library(JsonLibrary library) {
        this.library = library;
        return this;
    }

    public JsonDataFormat unmarshalType(String unmarshalType) {
        this.unmarshalTypeName = unmarshalType;
        return this;
    }

    public JsonDataFormat unmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
        return this;
    }

    public JsonDataFormat jsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
        return this;
    }

    public JsonDataFormat include(String include) {
        this.include = include;
        return this;
    }

    public JsonDataFormat allowJmsType(boolean allowJmsType) {
        return this.allowJmsType(Boolean.toString(allowJmsType));
    }

    public JsonDataFormat allowJmsType(String allowJmsType) {
        this.allowJmsType = allowJmsType;
        return this;
    }

    public JsonDataFormat collectionType(String collectionType) {
        this.collectionTypeName = collectionType;
        return this;
    }

    public JsonDataFormat collectionType(Class<?> collectionType) {
        this.collectionType = collectionType;
        return this;
    }

    public JsonDataFormat useList(boolean useList) {
        return this.useList(Boolean.toString(useList));
    }

    public JsonDataFormat useList(String useList) {
        this.useList = useList;
        return this;
    }

    public JsonDataFormat moduleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
        return this;
    }

    public JsonDataFormat moduleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
        return this;
    }

    public JsonDataFormat enableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
        return this;
    }

    public JsonDataFormat disableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
        return this;
    }

    public JsonDataFormat allowUnmarshallType(boolean allowUnmarshallType) {
        return this.allowUnmarshallType(Boolean.toString(allowUnmarshallType));
    }

    public JsonDataFormat allowUnmarshallType(String allowUnmarshallType) {
        this.allowUnmarshallType = allowUnmarshallType;
        return this;
    }

    public JsonDataFormat timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    public JsonDataFormat autoDiscoverObjectMapper(boolean autoDiscoverObjectMapper) {
        return this.autoDiscoverObjectMapper(Boolean.toString(autoDiscoverObjectMapper));
    }

    public JsonDataFormat autoDiscoverObjectMapper(String autoDiscoverObjectMapper) {
        this.autoDiscoverObjectMapper = autoDiscoverObjectMapper;
        return this;
    }

    public JsonDataFormat namingStrategy(String namingStrategy) {
        this.namingStrategy = namingStrategy;
        return this;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<JsonDataFormat> {
        private String objectMapper;
        private String useDefaultObjectMapper;
        private String autoDiscoverObjectMapper;
        private String prettyPrint;
        private JsonLibrary library = JsonLibrary.Jackson;
        private String combineUnicodeSurrogates;
        private String unmarshalTypeName;
        private Class<?> unmarshalType;
        private String jsonViewTypeName;
        private Class<?> jsonView;
        private String include;
        private String allowJmsType;
        private String collectionTypeName;
        private Class<?> collectionType;
        private String useList;
        private String moduleClassNames;
        private String moduleRefs;
        private String enableFeatures;
        private String disableFeatures;
        private String allowUnmarshallType;
        private String timezone;
        private String schemaResolver;
        private String autoDiscoverSchemaResolver;
        private String namingStrategy;
        private String contentTypeHeader;
        private String dateFormatPattern;
        private String maxStringLength;

        public Builder contentTypeHeader(String contentTypeHeader) {
            this.contentTypeHeader = contentTypeHeader;
            return this;
        }

        public Builder contentTypeHeader(boolean contentTypeHeader) {
            this.contentTypeHeader = Boolean.toString(contentTypeHeader);
            return this;
        }

        public Builder dateFormatPattern(String dateFormatPattern) {
            this.dateFormatPattern = dateFormatPattern;
            return this;
        }

        public Builder objectMapper(String objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder useDefaultObjectMapper(String useDefaultObjectMapper) {
            this.useDefaultObjectMapper = useDefaultObjectMapper;
            return this;
        }

        public Builder useDefaultObjectMapper(boolean useDefaultObjectMapper) {
            this.useDefaultObjectMapper = Boolean.toString(useDefaultObjectMapper);
            return this;
        }

        public Builder prettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public Builder prettyPrint(boolean prettyPrint) {
            this.prettyPrint = Boolean.toString(prettyPrint);
            return this;
        }

        public Builder unmarshalTypeName(String unmarshalTypeName) {
            this.unmarshalTypeName = unmarshalTypeName;
            return this;
        }

        public Builder unmarshalType(Class<?> unmarshalType) {
            this.unmarshalType = unmarshalType;
            return this;
        }

        public Builder library(JsonLibrary library) {
            this.library = library;
            return this;
        }

        public Builder combineUnicodeSurrogates(boolean combineUnicodeSurrogates) {
            this.combineUnicodeSurrogates = Boolean.toString(combineUnicodeSurrogates);
            return this;
        }

        public Builder combineUnicodeSurrogates(String combineUnicodeSurrogates) {
            this.combineUnicodeSurrogates = combineUnicodeSurrogates;
            return this;
        }

        public Builder jsonViewTypeName(String jsonViewTypeName) {
            this.jsonViewTypeName = jsonViewTypeName;
            return this;
        }

        public Builder jsonView(Class<?> jsonView) {
            this.jsonView = jsonView;
            return this;
        }

        public Builder include(String include) {
            this.include = include;
            return this;
        }

        public Builder allowJmsType(String allowJmsType) {
            this.allowJmsType = allowJmsType;
            return this;
        }

        public Builder allowJmsType(boolean allowJmsType) {
            this.allowJmsType = Boolean.toString(allowJmsType);
            return this;
        }

        public Builder collectionTypeName(String collectionTypeName) {
            this.collectionTypeName = collectionTypeName;
            return this;
        }

        public Builder collectionType(Class<?> collectionType) {
            this.collectionType = collectionType;
            return this;
        }

        public Builder useList(String useList) {
            this.useList = useList;
            return this;
        }

        public Builder useList(boolean useList) {
            this.useList = Boolean.toString(useList);
            return this;
        }

        public Builder moduleClassNames(String moduleClassNames) {
            this.moduleClassNames = moduleClassNames;
            return this;
        }

        public Builder moduleRefs(String moduleRefs) {
            this.moduleRefs = moduleRefs;
            return this;
        }

        public Builder enableFeatures(String enableFeatures) {
            this.enableFeatures = enableFeatures;
            return this;
        }

        public Builder disableFeatures(String disableFeatures) {
            this.disableFeatures = disableFeatures;
            return this;
        }

        public Builder allowUnmarshallType(String allowUnmarshallType) {
            this.allowUnmarshallType = allowUnmarshallType;
            return this;
        }

        public Builder allowUnmarshallType(boolean allowUnmarshallType) {
            this.allowUnmarshallType = Boolean.toString(allowUnmarshallType);
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder autoDiscoverObjectMapper(String autoDiscoverObjectMapper) {
            this.autoDiscoverObjectMapper = autoDiscoverObjectMapper;
            return this;
        }

        public Builder autoDiscoverObjectMapper(boolean autoDiscoverObjectMapper) {
            this.autoDiscoverObjectMapper = Boolean.toString(autoDiscoverObjectMapper);
            return this;
        }

        public Builder schemaResolver(String schemaResolver) {
            this.schemaResolver = schemaResolver;
            return this;
        }

        public Builder autoDiscoverSchemaResolver(String autoDiscoverSchemaResolver) {
            this.autoDiscoverSchemaResolver = autoDiscoverSchemaResolver;
            return this;
        }

        public Builder autoDiscoverSchemaResolver(boolean autoDiscoverSchemaResolver) {
            this.autoDiscoverSchemaResolver = Boolean.toString(autoDiscoverSchemaResolver);
            return this;
        }

        public Builder namingStrategy(String namingStrategy) {
            this.namingStrategy = namingStrategy;
            return this;
        }

        public Builder maxStringLength(String maxStringLength) {
            this.maxStringLength = maxStringLength;
            return this;
        }

        @Override
        public JsonDataFormat end() {
            return new JsonDataFormat(this);
        }
    }
}

