/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.camel.CamelContext;
import org.apache.camel.Converter;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.PluginHelper;

@Converter(generateBulkLoader=true)
public final class ResourceConverter {
    private ResourceConverter() {
    }

    @Converter(order=1)
    public static InputStream toInputStream(Resource resource) throws IOException {
        return resource.getInputStream();
    }

    @Converter(order=2)
    public static Reader toReader(Resource resource) throws Exception {
        return resource.getReader();
    }

    @Converter(order=3)
    public static byte[] toByteArray(Resource resource, CamelContext camelContext) throws IOException {
        InputStream is = resource.getInputStream();
        return (byte[])camelContext.getTypeConverter().tryConvertTo(byte[].class, (Object)is);
    }

    @Converter(order=4)
    public static String toString(Resource resource, CamelContext camelContext) throws IOException {
        InputStream is = resource.getInputStream();
        return (String)camelContext.getTypeConverter().tryConvertTo(String.class, (Object)is);
    }

    @Converter(order=5)
    public static Resource toResource(String uri, CamelContext camelContext) {
        return PluginHelper.getResourceLoader((CamelContext)camelContext).resolveResource(uri);
    }
}

