/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.request.JolokiaObjectNameRequest;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.request.RequestCreator;
import org.jolokia.server.core.util.EscapeUtil;
import org.jolokia.server.core.util.RequestType;

public class JolokiaExecRequest
extends JolokiaObjectNameRequest {
    private final String operation;
    private List<?> arguments;
    private boolean pathCreated;

    JolokiaExecRequest(String pObjectName, String pOperation, List<?> pArguments, ProcessingParameters pParams) throws MalformedObjectNameException {
        super(RequestType.EXEC, pObjectName, null, pParams, true);
        this.operation = pOperation;
        this.arguments = pArguments;
    }

    JolokiaExecRequest(Map<String, ?> pRequestMap, ProcessingParameters pParams) throws MalformedObjectNameException {
        super(pRequestMap, pParams, true);
        this.arguments = (List)pRequestMap.get("arguments");
        this.operation = (String)pRequestMap.get("operation");
    }

    public JolokiaExecRequest withChangedObjectName(ObjectName name) {
        try {
            return new JolokiaExecRequest(name.getCanonicalName(), this.operation, this.arguments, this.processingConfig);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public String getOperation() {
        return this.operation;
    }

    public List<?> getArguments() {
        return this.arguments;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject ret = super.toJSON();
        if (this.arguments != null && !this.arguments.isEmpty()) {
            ret.put((Object)"arguments", this.arguments);
        }
        ret.put((Object)"operation", (Object)this.operation);
        return ret;
    }

    public void splitArgumentsAndPath(int nrParams, List<String> pathParts) {
        if (this.pathCreated) {
            return;
        }
        this.arguments = this.arguments.subList(0, nrParams);
        this.setPathParts(pathParts);
        this.pathCreated = true;
    }

    static RequestCreator<JolokiaExecRequest> newCreator() {
        return new RequestCreator<JolokiaExecRequest>(){

            @Override
            public JolokiaExecRequest create(Deque<String> pStack, ProcessingParameters pParams) throws MalformedObjectNameException {
                return new JolokiaExecRequest(pStack.pop(), pStack.pop(), JolokiaExecRequest.convertSpecialStringTags(this.prepareExtraArgs(pStack)), pParams);
            }

            @Override
            public JolokiaExecRequest create(JSONObject requestMap, ProcessingParameters pParams) throws MalformedObjectNameException {
                return new JolokiaExecRequest((Map<String, ?>)requestMap, pParams);
            }
        };
    }

    private static List<String> convertSpecialStringTags(List<String> extraArgs) {
        if (extraArgs == null) {
            return null;
        }
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : extraArgs) {
            args.add(EscapeUtil.convertSpecialStringTags(arg));
        }
        return args;
    }

    public String toString() {
        String baseInfo;
        StringBuilder ret = new StringBuilder("JmxExecRequest[");
        ret.append("operation=").append(this.getOperation());
        if (this.arguments != null && !this.arguments.isEmpty()) {
            ret.append(", arguments=").append(this.getArguments());
        }
        if ((baseInfo = this.getInfo()) != null) {
            ret.append(", ").append(baseInfo);
        }
        ret.append("]");
        return ret.toString();
    }
}

